/*
 * Decompiled with CFR 0.152.
 */
package ortus.boxlang.runtime.validation.dynamic;

import java.util.Set;
import ortus.boxlang.runtime.context.IBoxContext;
import ortus.boxlang.runtime.dynamic.casters.GenericCaster;
import ortus.boxlang.runtime.scopes.Key;
import ortus.boxlang.runtime.types.IStruct;
import ortus.boxlang.runtime.types.exceptions.BoxValidationException;
import ortus.boxlang.runtime.validation.Validatable;
import ortus.boxlang.runtime.validation.Validator;

public class TypeOneOf
implements Validator {
    private final Set<String> validTypes;

    public TypeOneOf(Set<String> validTypes) {
        this.validTypes = validTypes;
    }

    @Override
    public void validate(IBoxContext context, Key caller, Validatable record, IStruct records) {
        if (records.containsKey(record.name())) {
            Object value = records.get(record.name());
            if (!this.validTypes.stream().anyMatch(type -> GenericCaster.attempt(context, value, type).wasSuccessful())) {
                throw new BoxValidationException(caller, record, "must be one of the following types: " + String.join((CharSequence)", ", this.validTypes));
            }
        }
    }
}

