/*
 * Decompiled with CFR 0.152.
 */
package ortus.boxlang.runtime.validation.dynamic;

import java.util.Set;
import ortus.boxlang.runtime.context.IBoxContext;
import ortus.boxlang.runtime.scopes.Key;
import ortus.boxlang.runtime.types.IStruct;
import ortus.boxlang.runtime.types.exceptions.BoxValidationException;
import ortus.boxlang.runtime.validation.Validatable;
import ortus.boxlang.runtime.validation.Validator;

public class ValueOneOf
implements Validator {
    private Set<String> validValues;

    public ValueOneOf(Set<String> validValues) {
        this.validValues = validValues;
    }

    @Override
    public void validate(IBoxContext context, Key caller, Validatable record, IStruct records) {
        String value;
        if (records.containsKey(record.name()) && (value = records.getAsString(record.name())) != null) {
            if (!this.validValues.stream().map(String::toLowerCase).anyMatch(value.toLowerCase()::equals)) {
                throw new BoxValidationException(caller, record, "must be one of the following values: " + String.join((CharSequence)", ", this.validValues));
            }
        }
    }
}

