/*
 * Decompiled with CFR 0.152.
 */
package ortus.boxlang.runtime.validation.dynamic;

import java.util.ArrayList;
import java.util.Set;
import ortus.boxlang.runtime.context.IBoxContext;
import ortus.boxlang.runtime.scopes.Key;
import ortus.boxlang.runtime.types.IStruct;
import ortus.boxlang.runtime.types.exceptions.BoxValidationException;
import ortus.boxlang.runtime.validation.Validatable;
import ortus.boxlang.runtime.validation.Validator;

public class ValueRequires
implements Validator {
    private final Set<Key> recordNames;
    private final String value;

    public ValueRequires(String value, Set<Key> recordNames) {
        this.recordNames = recordNames;
        this.value = value;
    }

    @Override
    public void validate(IBoxContext context, Key caller, Validatable record, IStruct records) {
        if (records.containsKey(record.name()) && records.getAsString(record.name()).equalsIgnoreCase(this.value)) {
            ArrayList<String> missingAttributes = new ArrayList<String>();
            for (Key required : this.recordNames) {
                if (records.containsKey(required)) continue;
                missingAttributes.add(required.getName());
            }
            if (!missingAttributes.isEmpty()) {
                String missingAttributesString = String.join((CharSequence)", ", missingAttributes);
                throw new BoxValidationException(caller, record, "requires the following records to be present: " + missingAttributesString);
            }
        }
    }
}

