/*
 * Decompiled with CFR 0.152.
 */
package ortus.boxlang.runtime.validation.dynamic;

import java.util.Set;
import java.util.stream.Collectors;
import ortus.boxlang.runtime.context.IBoxContext;
import ortus.boxlang.runtime.scopes.Key;
import ortus.boxlang.runtime.types.IStruct;
import ortus.boxlang.runtime.types.exceptions.BoxValidationException;
import ortus.boxlang.runtime.validation.Validatable;
import ortus.boxlang.runtime.validation.Validator;

public class ValueRequiresOneOf
implements Validator {
    private final Set<Key> recordNames;
    private final String value;

    public ValueRequiresOneOf(String value, Set<Key> recordNames) {
        this.recordNames = recordNames;
        this.value = value;
    }

    @Override
    public void validate(IBoxContext context, Key caller, Validatable record, IStruct records) {
        if (records.containsKey(record.name()) && records.getAsString(record.name()).equalsIgnoreCase(this.value)) {
            if (!this.recordNames.stream().anyMatch(records::containsKey)) {
                throw new BoxValidationException(caller, record, "requires the one of the following attributes or arguments to be provided: " + this.recordNames.stream().map(Key::getName).collect(Collectors.joining(", ")));
            }
        }
    }
}

