/*
 * Decompiled with CFR 0.152.
 */
package ortus.boxlang.web;

import io.undertow.Handlers;
import io.undertow.Undertow;
import io.undertow.predicate.Predicates;
import io.undertow.server.HttpHandler;
import io.undertow.server.HttpServerExchange;
import io.undertow.server.handlers.encoding.ContentEncodingRepository;
import io.undertow.server.handlers.encoding.EncodingHandler;
import io.undertow.server.handlers.encoding.GzipEncodingProvider;
import io.undertow.server.handlers.resource.PathResourceManager;
import io.undertow.server.handlers.resource.ResourceHandler;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.List;
import java.util.Map;
import ortus.boxlang.runtime.BoxRuntime;
import ortus.boxlang.runtime.scopes.Key;
import ortus.boxlang.runtime.types.IStruct;
import ortus.boxlang.web.handlers.BLHandler;
import ortus.boxlang.web.handlers.WebsocketHandler;
import ortus.boxlang.web.handlers.WelcomeFileHandler;

public class MiniServer {
    public static boolean shuttingDown = false;
    public static WebsocketHandler websocketHandler;
    private static final ThreadLocal<HttpServerExchange> currentExchange;

    public static void main(String[] args) {
        Map<String, String> envVars = System.getenv();
        int port = Integer.parseInt(envVars.getOrDefault("BOXLANG_PORT", "8080"));
        String webRoot = envVars.getOrDefault("BOXLANG_WEBROOT", "");
        Boolean debug = null;
        String host = envVars.getOrDefault("BOXLANG_HOST", "localhost");
        String configPath = envVars.getOrDefault("BOXLANG_CONFIG", null);
        String serverHome = envVars.getOrDefault("BOXLANG_HOME", null);
        for (int i = 0; i < args.length; ++i) {
            if (args[i].equalsIgnoreCase("--port") || args[i].equalsIgnoreCase("-p")) {
                port = Integer.parseInt(args[++i]);
            }
            if (args[i].equalsIgnoreCase("--webroot") || args[i].equalsIgnoreCase("-w")) {
                webRoot = args[++i];
            }
            if (args[i].equalsIgnoreCase("--debug") || args[i].equalsIgnoreCase("-d")) {
                debug = true;
            }
            if (args[i].equalsIgnoreCase("--host") || args[i].equalsIgnoreCase("-h")) {
                host = args[++i];
            }
            if (args[i].equalsIgnoreCase("--configPath") || args[i].equalsIgnoreCase("-c")) {
                configPath = args[++i];
            }
            if (!args[i].equalsIgnoreCase("--serverHome") && !args[i].equalsIgnoreCase("-s")) continue;
            serverHome = args[++i];
        }
        Path absWebRoot = Paths.get(webRoot, new String[0]).normalize();
        if (!absWebRoot.isAbsolute()) {
            absWebRoot = Paths.get("", new String[0]).resolve(webRoot).normalize().toAbsolutePath().normalize();
        }
        if (!absWebRoot.toFile().exists()) {
            System.out.println("Web Root does not exist, cannot continue: " + absWebRoot.toString());
            System.exit(1);
        }
        long sTime = System.currentTimeMillis();
        System.out.println("+ Starting BoxLang Server...");
        System.out.println("  - Web Root: " + absWebRoot.toString());
        System.out.println("  - Host: " + host);
        System.out.println("  - Port: " + port);
        System.out.println("  - Debug: " + debug);
        System.out.println("  - Config Path: " + configPath);
        System.out.println("  - Server Home: " + serverHome);
        System.out.println("+ Starting BoxLang Runtime...");
        BoxRuntime runtime = BoxRuntime.getInstance(debug, configPath, serverHome);
        IStruct versionInfo = runtime.getVersionInfo();
        System.out.println("  - BoxLang Version: " + versionInfo.getAsString(Key.of("version")) + " (Built On: " + versionInfo.getAsString(Key.of("buildDate")) + ")");
        Undertow.Builder builder = Undertow.builder();
        PathResourceManager resourceManager = new PathResourceManager(absWebRoot);
        System.out.println("  - Runtime Started in " + (System.currentTimeMillis() - sTime) + "ms");
        HttpHandler httpHandler = new EncodingHandler(new ContentEncodingRepository().addEncodingHandler("gzip", new GzipEncodingProvider(), 50, Predicates.parse("request-larger-than(1500)"))).setNext(new WelcomeFileHandler(Handlers.predicate(Predicates.parse("regex( '^(/.+?\\.cfml|/.+?\\.cf[cms]|.+?\\.bx[ms]{0,1})(/.*)?$' )"), new BLHandler(absWebRoot.toString()), new ResourceHandler(resourceManager).setDirectoryListingEnabled(true)), resourceManager, List.of("index.bxm", "index.bxs", "index.cfm", "index.cfs", "index.htm", "index.html")));
        httpHandler = new WebsocketHandler(httpHandler, "/ws");
        websocketHandler = (WebsocketHandler)httpHandler;
        System.out.println("+ WebSocket Server started");
        final HttpHandler finalHttpHandler = httpHandler;
        httpHandler = new HttpHandler(){

            @Override
            public void handleRequest(HttpServerExchange exchange) throws Exception {
                try {
                    MiniServer.setCurrentExchange(exchange);
                    finalHttpHandler.handleRequest(exchange);
                }
                finally {
                    MiniServer.setCurrentExchange(null);
                }
            }

            public String toString() {
                return "Websocket Exchange Setter Handler";
            }
        };
        Undertow BLServer = builder.addHttpListener(port, host).setHandler(httpHandler).build();
        Runtime.getRuntime().addShutdownHook(new Thread(() -> {
            shuttingDown = true;
            System.out.println("Shutting down BoxLang Server...");
            BLServer.stop();
            runtime.shutdown();
            System.out.println("BoxLang Server stopped.");
        }));
        System.out.println("+ BoxLang MiniServer started in " + (System.currentTimeMillis() - sTime) + "ms at: http://" + host + ":" + port);
        System.out.println("Press Ctrl+C to stop the server.");
        BLServer.start();
    }

    public static HttpServerExchange getCurrentExchange() {
        return currentExchange.get();
    }

    public static void setCurrentExchange(HttpServerExchange exchange) {
        currentExchange.set(exchange);
    }

    public static WebsocketHandler getWebsocketHandler() {
        return websocketHandler;
    }

    static {
        currentExchange = new ThreadLocal();
    }
}

