/*
 * Decompiled with CFR 0.152.
 */
package ortus.boxlang.web.bifs;

import java.io.IOException;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.attribute.FileTime;
import java.util.Set;
import java.util.stream.Stream;
import ortus.boxlang.compiler.parser.Parser;
import ortus.boxlang.runtime.bifs.BIF;
import ortus.boxlang.runtime.bifs.BoxBIF;
import ortus.boxlang.runtime.bifs.BoxBIFs;
import ortus.boxlang.runtime.context.IBoxContext;
import ortus.boxlang.runtime.context.RequestBoxContext;
import ortus.boxlang.runtime.dynamic.casters.StringCaster;
import ortus.boxlang.runtime.scopes.ArgumentsScope;
import ortus.boxlang.runtime.scopes.Key;
import ortus.boxlang.runtime.types.Argument;
import ortus.boxlang.runtime.types.DateTime;
import ortus.boxlang.runtime.types.IStruct;
import ortus.boxlang.runtime.types.Struct;
import ortus.boxlang.runtime.types.exceptions.BoxIOException;
import ortus.boxlang.runtime.types.exceptions.BoxRuntimeException;
import ortus.boxlang.runtime.types.util.BLCollector;
import ortus.boxlang.runtime.types.util.ListUtil;
import ortus.boxlang.runtime.util.FileSystemUtil;
import ortus.boxlang.runtime.validation.Validator;
import ortus.boxlang.web.context.WebRequestBoxContext;
import ortus.boxlang.web.exchange.IBoxHTTPExchange;
import ortus.boxlang.web.util.KeyDictionary;

@BoxBIFs(value={@BoxBIF, @BoxBIF(alias="FileUploadAll")})
public class FileUpload
extends BIF {
    public FileUpload() {
        this.declaredArguments = new Argument[]{new Argument(true, "string", Key.destination), new Argument(false, "string", Key.filefield), new Argument(false, "string", Key.accept), new Argument(false, "string", Key.nameconflict, (Object)"error", Set.of(Validator.valueOneOf("error", "skip", "overwrite", "makeunique"))), new Argument(false, "boolean", Key.strict, true), new Argument(false, "string", KeyDictionary.allowedExtensions)};
    }

    @Override
    public Object _invoke(IBoxContext context, ArgumentsScope arguments) {
        WebRequestBoxContext requestContext = context.getParentOfType(WebRequestBoxContext.class);
        Key bifMethodKey = arguments.getAsKey(BIF.__functionName);
        IBoxHTTPExchange exchange = requestContext.getHTTPExchange();
        IBoxHTTPExchange.FileUpload[] uploads = exchange.getUploadData();
        if (uploads == null) {
            throw new BoxRuntimeException("No file uploads were found in the request");
        }
        if (bifMethodKey.equals(KeyDictionary.fileUpload)) {
            String field = arguments.getAsString(Key.filefield);
            if (field == null) {
                field = uploads[0].formFieldName().getName();
            }
            Key fieldKey = Key.of(field);
            IBoxHTTPExchange.FileUpload upload2 = null;
            if (fieldKey == null) {
                upload2 = uploads[0];
            } else {
                upload2 = Stream.of(uploads).filter(u -> u.formFieldName().equals(fieldKey)).findFirst().orElse(null);
                if (upload2 == null) {
                    throw new BoxRuntimeException("The specified file field [" + fieldKey.getName() + "] was not found in the upload data");
                }
            }
            return this.uploadFile(upload2, arguments, context);
        }
        return Stream.of(uploads).map(upload -> this.uploadFile((IBoxHTTPExchange.FileUpload)upload, arguments, context)).collect(BLCollector.toArray());
    }

    private IStruct uploadFile(IBoxHTTPExchange.FileUpload upload, IStruct arguments, IBoxContext context) {
        String destination = arguments.getAsString(Key.destination);
        Path destinationPath = null;
        Boolean createPath = false;
        if (!Path.of(destination, new String[0]).isAbsolute()) {
            destinationPath = Path.of(FileSystemUtil.getTempDirectory(), destination);
            createPath = true;
        } else {
            destinationPath = FileSystemUtil.expandPath(context, destination).absolutePath();
        }
        if (!Files.isDirectory(destinationPath, new LinkOption[0])) {
            throw new BoxRuntimeException("The specified destination path [" + destination + "] is not a directory");
        }
        if (!Files.exists(destinationPath, new LinkOption[0]) && createPath.booleanValue()) {
            try {
                Files.createDirectories(destinationPath, new FileAttribute[0]);
            }
            catch (IOException e) {
                throw new BoxIOException("The specified destination path [" + destination + "] could not be created", e);
            }
        }
        if (!Files.exists(destinationPath, new LinkOption[0])) {
            throw new BoxRuntimeException("The specified destination path [" + destination + "] does not exist");
        }
        Object fileName = upload.originalFileName();
        String extension = Parser.getFileExtension((String)fileName).get();
        Path filePath = destinationPath.resolve((String)fileName);
        String nameConflict = arguments.getAsString(Key.nameconflict).toLowerCase();
        IStruct uploadRecord = this.newUploadRecord();
        uploadRecord.put(KeyDictionary.clientDirectory, (Object)destinationPath.toString());
        uploadRecord.put(KeyDictionary.clientFile, (Object)filePath.toString());
        uploadRecord.put(KeyDictionary.clientFileExt, (Object)extension);
        uploadRecord.put(KeyDictionary.clientFileName, fileName);
        uploadRecord.put(KeyDictionary.attemptedServerFile, (Object)filePath.toString());
        try {
            uploadRecord.put(KeyDictionary.fileSize, (Object)Files.size(upload.tmpPath()));
        }
        catch (IOException e) {
            throw new BoxIOException("The size of the uploaded file [" + (String)fileName + "] could not be determined", e);
        }
        Boolean uploadPermitted = this.processUploadSecurity(upload, arguments, context);
        if (!uploadPermitted.booleanValue()) {
            try {
                Files.delete(upload.tmpPath());
            }
            catch (IOException e) {
                throw new BoxIOException("The uploaded file [" + upload.tmpPath().toString() + "] was marked as unsafe but could not be deleted.", e);
            }
            if (arguments.getAsBoolean(Key.strict).booleanValue()) {
                throw new BoxRuntimeException("The the upload of file [" + (String)fileName + "] is not permitted by the server, application or request file security settings");
            }
            return uploadRecord;
        }
        DateTime operationDate = new DateTime();
        uploadRecord.put(KeyDictionary.timeCreated, (Object)operationDate);
        if (Files.exists(filePath, new LinkOption[0])) {
            uploadRecord.put(KeyDictionary.fileExisted, (Object)true);
            try {
                uploadRecord.put(KeyDictionary.timeCreated, (Object)new DateTime(((FileTime)Files.getAttribute(filePath, "creationTime", new LinkOption[0])).toInstant()));
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            try {
                uploadRecord.put(KeyDictionary.oldFileSize, (Object)Files.size(filePath));
            }
            catch (IOException e) {
                throw new BoxIOException("The size of the original file [" + (String)fileName + "] could not be determined", e);
            }
            switch (nameConflict) {
                case "error": {
                    throw new BoxRuntimeException("The file [" + (String)fileName + "] already exists in the destination path [" + destination + "]");
                }
                case "skip": {
                    return uploadRecord;
                }
                case "overwrite": {
                    try {
                        Files.delete(filePath);
                        uploadRecord.put(KeyDictionary.fileWasOverwritten, (Object)true);
                        break;
                    }
                    catch (IOException e) {
                        throw new BoxIOException("The file [" + (String)fileName + "] could not be deleted from the destination path [" + destination + "]", e);
                    }
                }
                case "makeunique": {
                    String baseName = ((String)fileName).substring(0, ((String)fileName).length() - extension.length() - 1);
                    fileName = baseName + "_" + System.currentTimeMillis() + "." + extension;
                    filePath = destinationPath.resolve((String)fileName);
                    uploadRecord.put(KeyDictionary.fileWasRenamed, (Object)true);
                }
            }
        }
        try {
            Files.move(upload.tmpPath(), filePath, new CopyOption[0]);
            String mimeType = Files.probeContentType(filePath);
            if (mimeType == null) {
                mimeType = "application/octet-stream";
            }
            uploadRecord.put(KeyDictionary.contentType, (Object)mimeType);
            uploadRecord.put(KeyDictionary.contentSubType, ListUtil.asList(mimeType, "/").get(1));
            uploadRecord.put(KeyDictionary.timeLastModified, (Object)operationDate);
            uploadRecord.put(KeyDictionary.dateLastAccessed, (Object)operationDate);
            uploadRecord.put(KeyDictionary.serverFile, (Object)filePath.toString());
            uploadRecord.put(KeyDictionary.serverFileExt, (Object)extension);
            uploadRecord.put(KeyDictionary.serverFileName, fileName);
            uploadRecord.put(KeyDictionary.serverDirectory, (Object)filePath.getParent().toString());
            uploadRecord.put(KeyDictionary.fileSize, (Object)Files.size(filePath));
            uploadRecord.put(KeyDictionary.fileWasSaved, (Object)true);
        }
        catch (IOException e) {
            throw new BoxIOException("The uploaded file [" + (String)fileName + "] could not be saved to the destination path [" + destination + "]", e);
        }
        return uploadRecord;
    }

    private IStruct newUploadRecord() {
        return Struct.of(KeyDictionary.attemptedServerFile, null, KeyDictionary.clientDirectory, null, KeyDictionary.clientFile, null, KeyDictionary.clientFileExt, null, KeyDictionary.clientFileName, null, KeyDictionary.contentSubType, null, KeyDictionary.contentType, null, KeyDictionary.dateLastAccessed, null, KeyDictionary.fileExisted, false, KeyDictionary.fileSize, null, KeyDictionary.fileWasAppended, false, KeyDictionary.fileWasOverwritten, false, KeyDictionary.fileWasRenamed, false, KeyDictionary.fileWasSaved, false, KeyDictionary.oldFileSize, null, KeyDictionary.serverDirectory, null, KeyDictionary.serverFile, null, KeyDictionary.serverFileExt, null, KeyDictionary.serverFileName, null, KeyDictionary.timeCreated, null, KeyDictionary.timeLastModified, null);
    }

    public boolean processUploadSecurity(IBoxHTTPExchange.FileUpload upload, IStruct arguments, IBoxContext context) {
        IStruct requestSettings = context.getParentOfType(RequestBoxContext.class).getSettings();
        String uploadMimeType = FileSystemUtil.getMimeType(upload.tmpPath().toString());
        String uploadExtension = Parser.getFileExtension(upload.tmpPath().getFileName().toString()).get().toLowerCase();
        String allowedExtensions = arguments.getAsString(KeyDictionary.allowedExtensions);
        String allowedMimeTypes = arguments.getAsString(Key.accept);
        Boolean strict = arguments.getAsBoolean(Key.strict);
        Boolean hasServerPermission = true;
        Boolean hasRequestPermission = true;
        if (allowedExtensions != null) {
            hasRequestPermission = ListUtil.asList(allowedExtensions, ",").stream().map(StringCaster::cast).anyMatch(ext -> ext.equals("*") || ext.equalsIgnoreCase(uploadExtension));
        } else if (allowedMimeTypes != null) {
            hasRequestPermission = ListUtil.asList(allowedMimeTypes, ",").stream().map(StringCaster::cast).anyMatch(ext -> ext.equals("*") || ext.equalsIgnoreCase(uploadMimeType));
        }
        hasServerPermission = this.runtime.getConfiguration().security.isExtensionAllowed(uploadExtension);
        return strict.booleanValue() ? hasServerPermission.booleanValue() && hasRequestPermission.booleanValue() : (allowedExtensions != null || allowedMimeTypes != null ? hasRequestPermission : hasServerPermission);
    }
}

