/*
 * Decompiled with CFR 0.152.
 */
package ortus.boxlang.web.bifs;

import java.util.Set;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;
import ortus.boxlang.runtime.bifs.BIF;
import ortus.boxlang.runtime.bifs.BoxBIF;
import ortus.boxlang.runtime.context.IBoxContext;
import ortus.boxlang.runtime.context.RequestBoxContext;
import ortus.boxlang.runtime.scopes.ArgumentsScope;
import ortus.boxlang.runtime.scopes.Key;
import ortus.boxlang.runtime.types.Argument;
import ortus.boxlang.runtime.types.Array;
import ortus.boxlang.runtime.validation.Validator;
import ortus.boxlang.web.util.KeyDictionary;

@BoxBIF
public class HtmlHead
extends BIF {
    public HtmlHead() {
        this.declaredArguments = new Argument[]{new Argument(true, "string", Key.text, Set.of(Validator.NON_EMPTY))};
    }

    @Override
    public Object _invoke(IBoxContext context, ArgumentsScope arguments) {
        String text = arguments.getAsString(Key.text).trim();
        HtmlHead.addToHead(context, text);
        return true;
    }

    public static void addToHead(IBoxContext context, String text) {
        if (!context.hasAttachment(KeyDictionary.htmlHead)) {
            context.putAttachment(KeyDictionary.htmlHead, new Array());
            context.getParentOfType(RequestBoxContext.class).getApplicationListener().getInterceptorPool().register(data -> {
                IBoxContext dataContext = (IBoxContext)data.get(Key.context);
                if (dataContext.hasAttachment(KeyDictionary.htmlHead)) {
                    Array headArray = (Array)dataContext.getAttachment(KeyDictionary.htmlHead);
                    StringBuffer buffer = dataContext.getBuffer();
                    Document doc = Jsoup.parse((String)buffer.toString());
                    Element headElement = doc.head();
                    if (headElement == null) {
                        headElement = doc.appendElement("head");
                    }
                    for (Object headContent : headArray) {
                        headElement.append((String)headContent);
                    }
                    dataContext.clearBuffer();
                    dataContext.writeToBuffer(doc.toString());
                }
                return false;
            }, KeyDictionary.onRequestEnd);
        }
        Array head = (Array)context.getAttachment(KeyDictionary.htmlHead);
        head.append(text);
    }
}

