/*
 * Decompiled with CFR 0.152.
 */
package ortus.boxlang.web.components;

import java.util.Set;
import ortus.boxlang.runtime.components.Attribute;
import ortus.boxlang.runtime.components.BoxComponent;
import ortus.boxlang.runtime.components.Component;
import ortus.boxlang.runtime.context.IBoxContext;
import ortus.boxlang.runtime.scopes.Key;
import ortus.boxlang.runtime.types.IStruct;
import ortus.boxlang.runtime.validation.Validator;
import ortus.boxlang.web.context.WebRequestBoxContext;
import ortus.boxlang.web.exchange.BoxCookie;
import ortus.boxlang.web.exchange.IBoxHTTPExchange;

@BoxComponent
public class Cookie
extends Component {
    public Cookie() {
        this.declaredAttributes = new Attribute[]{new Attribute(Key._NAME, "string", Set.of(Validator.REQUIRED, Validator.NON_EMPTY)), new Attribute(Key.value, "string", ""), new Attribute(Key.secure, "boolean"), new Attribute(Key.httpOnly, "boolean"), new Attribute(Key.expires, "any"), new Attribute(Key.samesite, "string"), new Attribute(Key.path, "string"), new Attribute(Key.domain, "string")};
    }

    @Override
    public Component.BodyResult _invoke(IBoxContext context, IStruct attributes, Component.ComponentBody body, IStruct executionState) {
        String name = attributes.getAsString(Key._NAME);
        String value = attributes.getAsString(Key.value);
        Boolean secure = attributes.getAsBoolean(Key.secure);
        Boolean httpOnly = attributes.getAsBoolean(Key.httpOnly);
        Object expires = attributes.get(Key.requestTimeout);
        String samesite = attributes.getAsString(Key.samesite);
        String path = attributes.getAsString(Key.path);
        String domain = attributes.getAsString(Key.domain);
        WebRequestBoxContext requestContext = context.getParentOfType(WebRequestBoxContext.class);
        IBoxHTTPExchange exchange = requestContext.getHTTPExchange();
        BoxCookie cookieInstance = new BoxCookie(name, value);
        if (secure != null) {
            cookieInstance.setSecure(secure);
        }
        if (httpOnly != null) {
            cookieInstance.setHttpOnly(httpOnly);
        }
        if (path != null) {
            cookieInstance.setPath(path);
        }
        if (domain != null) {
            cookieInstance.setDomain(domain);
        }
        exchange.addResponseCookie(cookieInstance);
        requestContext.getCookieScope().put(name, (Object)value);
        return DEFAULT_RETURN;
    }
}

