/*
 * Decompiled with CFR 0.152.
 */
package ortus.boxlang.web.components;

import java.util.Set;
import ortus.boxlang.runtime.components.Attribute;
import ortus.boxlang.runtime.components.BoxComponent;
import ortus.boxlang.runtime.components.Component;
import ortus.boxlang.runtime.context.IBoxContext;
import ortus.boxlang.runtime.scopes.Key;
import ortus.boxlang.runtime.types.IStruct;
import ortus.boxlang.runtime.types.exceptions.BoxValidationException;
import ortus.boxlang.runtime.validation.Validator;
import ortus.boxlang.web.context.WebRequestBoxContext;
import ortus.boxlang.web.exchange.IBoxHTTPExchange;

@BoxComponent
public class Header
extends Component {
    public Header() {
        this.declaredAttributes = new Attribute[]{new Attribute(Key._NAME, "string", Set.of(Validator.NON_EMPTY, (context, caller, record, records) -> {
            if (!records.containsKey(Key.statusCode) && !records.containsKey(Key._NAME)) {
                throw new BoxValidationException(Key._NAME, record, "is required unless statusCode is provided.");
            }
        })), new Attribute(Key.value, "string", ""), new Attribute(Key.charset, "String", "UTF-8"), new Attribute(Key.statusCode, "integer", Set.of(Validator.min(100), Validator.max(599))), new Attribute(Key.statusText, "string", "")};
    }

    @Override
    public Component.BodyResult _invoke(IBoxContext context, IStruct attributes, Component.ComponentBody body, IStruct executionState) {
        String name = attributes.getAsString(Key._NAME);
        String value = attributes.getAsString(Key.value);
        String charset = attributes.getAsString(Key.charset);
        Integer statusCode = attributes.getAsInteger(Key.statusCode);
        String statusText = attributes.getAsString(Key.statusText);
        WebRequestBoxContext requestContext = context.getParentOfType(WebRequestBoxContext.class);
        IBoxHTTPExchange exchange = requestContext.getHTTPExchange();
        if (statusCode != null) {
            if (statusText != null) {
                exchange.setResponseStatus(statusCode, statusText);
            } else {
                exchange.setResponseStatus(statusCode);
            }
        } else {
            exchange.setResponseHeader(name, value);
        }
        return DEFAULT_RETURN;
    }
}

