/*
 * Decompiled with CFR 0.152.
 */
package ortus.boxlang.web.context;

import java.net.URI;
import java.util.Iterator;
import java.util.UUID;
import ortus.boxlang.runtime.BoxRuntime;
import ortus.boxlang.runtime.context.IBoxContext;
import ortus.boxlang.runtime.context.RequestBoxContext;
import ortus.boxlang.runtime.scopes.IScope;
import ortus.boxlang.runtime.scopes.Key;
import ortus.boxlang.runtime.scopes.VariablesScope;
import ortus.boxlang.runtime.types.IStruct;
import ortus.boxlang.runtime.types.Struct;
import ortus.boxlang.runtime.types.UDF;
import ortus.boxlang.runtime.types.exceptions.ScopeNotFoundException;
import ortus.boxlang.web.exchange.BoxCookie;
import ortus.boxlang.web.exchange.IBoxHTTPExchange;
import ortus.boxlang.web.scopes.CGIScope;
import ortus.boxlang.web.scopes.CookieScope;
import ortus.boxlang.web.scopes.FormScope;
import ortus.boxlang.web.scopes.RequestScope;
import ortus.boxlang.web.scopes.URLScope;

public class WebRequestBoxContext
extends RequestBoxContext {
    private static BoxRuntime runtime = BoxRuntime.getInstance();
    protected IScope variablesScope = new VariablesScope();
    protected IScope requestScope;
    protected IScope URLScope;
    protected IScope formScope;
    protected IScope CGIScope;
    protected IScope cookieScope;
    protected IBoxHTTPExchange httpExchange;
    protected Object requestBody = null;
    protected String webRoot;
    protected Key sessionID = null;

    public WebRequestBoxContext(IBoxContext parent, IBoxHTTPExchange httpExchange, String webRoot, URI template) {
        super(parent);
        httpExchange.setWebContext(this);
        this.httpExchange = httpExchange;
        this.webRoot = webRoot;
        this.URLScope = new URLScope(httpExchange);
        this.formScope = new FormScope(httpExchange);
        this.CGIScope = new CGIScope(httpExchange);
        this.cookieScope = new CookieScope(httpExchange);
        this.requestScope = new RequestScope(httpExchange);
    }

    public WebRequestBoxContext(IBoxContext parent, IBoxHTTPExchange exchange, String webRoot) {
        this(parent, exchange, webRoot, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Key getSessionID() {
        if (this.sessionID == null) {
            WebRequestBoxContext webRequestBoxContext = this;
            synchronized (webRequestBoxContext) {
                if (this.sessionID == null) {
                    BoxCookie sessionCookie = this.httpExchange.getRequestCookie("jsessionid");
                    if (sessionCookie != null) {
                        this.sessionID = Key.of(sessionCookie.getValue());
                    } else {
                        this.sessionID = Key.of(UUID.randomUUID().toString());
                        this.httpExchange.addResponseCookie(new BoxCookie("jsessionid", this.sessionID.getName()).setPath("/"));
                    }
                }
            }
        }
        return this.sessionID;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void resetSession() {
        WebRequestBoxContext webRequestBoxContext = this;
        synchronized (webRequestBoxContext) {
            this.sessionID = null;
            this.httpExchange.addResponseCookie(new BoxCookie("jsessionid", null));
            this.getApplicationListener().invalidateSession(this.getSessionID());
        }
    }

    @Override
    public IStruct getVisibleScopes(IStruct scopes, boolean nearby, boolean shallow) {
        if (this.hasParent().booleanValue() && !shallow) {
            this.getParent().getVisibleScopes(scopes, false, false);
        }
        scopes.getAsStruct(Key.contextual).put(ortus.boxlang.web.scopes.URLScope.name, (Object)this.URLScope);
        scopes.getAsStruct(Key.contextual).put(FormScope.name, (Object)this.formScope);
        scopes.getAsStruct(Key.contextual).put(ortus.boxlang.web.scopes.CGIScope.name, (Object)this.CGIScope);
        scopes.getAsStruct(Key.contextual).put(CookieScope.name, (Object)this.cookieScope);
        scopes.getAsStruct(Key.contextual).put(RequestScope.name, (Object)this.requestScope);
        if (nearby) {
            scopes.getAsStruct(Key.contextual).put(VariablesScope.name, (Object)this.variablesScope);
        }
        return super.getVisibleScopes(scopes, nearby, shallow);
    }

    @Override
    public IBoxContext.ScopeSearchResult scopeFindNearby(Key key, IScope defaultScope, boolean shallow) {
        IBoxContext.ScopeSearchResult querySearch = this.queryFindNearby(key);
        if (querySearch != null) {
            return querySearch;
        }
        Object result = this.variablesScope.getRaw(key);
        if (result != null) {
            return new IBoxContext.ScopeSearchResult(this.variablesScope, Struct.unWrapNull(result), key);
        }
        if (shallow) {
            return null;
        }
        return this.scopeFind(key, defaultScope);
    }

    @Override
    public IBoxContext.ScopeSearchResult scopeFind(Key key, IScope defaultScope) {
        if (key.equals(this.requestScope.getName())) {
            return new IBoxContext.ScopeSearchResult(this.requestScope, this.requestScope, key, true);
        }
        if (key.equals(this.CGIScope.getName())) {
            return new IBoxContext.ScopeSearchResult(this.CGIScope, this.CGIScope, key, true);
        }
        if (key.equals(this.URLScope.getName())) {
            return new IBoxContext.ScopeSearchResult(this.URLScope, this.URLScope, key, true);
        }
        if (key.equals(this.formScope.getName())) {
            return new IBoxContext.ScopeSearchResult(this.formScope, this.formScope, key, true);
        }
        if (key.equals(this.cookieScope.getName())) {
            return new IBoxContext.ScopeSearchResult(this.cookieScope, this.cookieScope, key, true);
        }
        Object result = this.CGIScope.getRaw(key);
        if (result != null) {
            return new IBoxContext.ScopeSearchResult(this.CGIScope, Struct.unWrapNull(result), key);
        }
        result = this.URLScope.getRaw(key);
        if (result != null) {
            return new IBoxContext.ScopeSearchResult(this.URLScope, Struct.unWrapNull(result), key);
        }
        result = this.formScope.getRaw(key);
        if (result != null) {
            return new IBoxContext.ScopeSearchResult(this.formScope, Struct.unWrapNull(result), key);
        }
        return super.scopeFind(key, defaultScope);
    }

    @Override
    public IScope getScope(Key name) throws ScopeNotFoundException {
        if (name.equals(this.requestScope.getName())) {
            return this.requestScope;
        }
        if (name.equals(this.URLScope.getName())) {
            return this.URLScope;
        }
        if (name.equals(this.formScope.getName())) {
            return this.formScope;
        }
        if (name.equals(this.CGIScope.getName())) {
            return this.CGIScope;
        }
        if (name.equals(this.cookieScope.getName())) {
            return this.cookieScope;
        }
        if (this.parent != null) {
            return this.parent.getScope(name);
        }
        throw new ScopeNotFoundException(String.format("The requested scope name [%s] was not located in any context", name.getName()));
    }

    @Override
    public IScope getScopeNearby(Key name, boolean shallow) throws ScopeNotFoundException {
        if (name.equals(this.variablesScope.getName())) {
            return this.variablesScope;
        }
        if (shallow) {
            return null;
        }
        return this.getScope(name);
    }

    @Override
    public void registerUDF(UDF udf, boolean override) {
        this.registerUDF(this.variablesScope, udf, override);
    }

    @Override
    public IScope getDefaultAssignmentScope() {
        return this.variablesScope;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IBoxContext flushBuffer(boolean force) {
        if (!this.canOutput().booleanValue() && !force) {
            return this;
        }
        String output = "";
        if (this.buffers.size() == 1) {
            StringBuffer buffer;
            StringBuffer stringBuffer = buffer = this.getBuffer();
            synchronized (stringBuffer) {
                output = buffer.toString();
                this.clearBuffer();
            }
        } else if (force) {
            Iterator iterator = this.buffers.iterator();
            while (iterator.hasNext()) {
                StringBuffer buf;
                StringBuffer stringBuffer = buf = (StringBuffer)iterator.next();
                synchronized (stringBuffer) {
                    output = output.concat(buf.toString());
                    buf.setLength(0);
                }
            }
        }
        if (!output.isEmpty()) {
            this.httpExchange.getResponseWriter().write(output);
            this.httpExchange.flushResponseBuffer();
        }
        return this;
    }

    public IBoxHTTPExchange getHTTPExchange() {
        return this.httpExchange;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getRequestBody() {
        if (this.requestBody != null) {
            return this.requestBody;
        }
        IBoxHTTPExchange iBoxHTTPExchange = this.httpExchange;
        synchronized (iBoxHTTPExchange) {
            if (this.requestBody != null) {
                return this.requestBody;
            }
            this.requestBody = this.httpExchange.getRequestBody();
        }
        return this.requestBody;
    }

    @Override
    public IStruct getConfig() {
        IStruct config = super.getConfig();
        config.getAsStruct(Key.mappings).put("/", (Object)this.webRoot);
        return config;
    }

    public String getWebRoot() {
        return this.webRoot;
    }

    public IScope getCookieScope() {
        return this.cookieScope;
    }
}

