/*
 * Decompiled with CFR 0.152.
 */
package ortus.boxlang.web.exchange;

import io.undertow.predicate.Predicate;
import io.undertow.security.api.SecurityContext;
import io.undertow.security.idm.Account;
import io.undertow.server.HttpServerExchange;
import io.undertow.server.handlers.Cookie;
import io.undertow.server.handlers.CookieImpl;
import io.undertow.server.handlers.form.FormData;
import io.undertow.server.handlers.form.FormDataParser;
import io.undertow.server.handlers.form.FormParserFactory;
import io.undertow.util.HeaderMap;
import io.undertow.util.HeaderValues;
import io.undertow.util.Headers;
import io.undertow.util.HttpString;
import io.undertow.util.LocaleUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.file.Path;
import java.security.Principal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Deque;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Scanner;
import org.xnio.channels.StreamSinkChannel;
import ortus.boxlang.runtime.scopes.Key;
import ortus.boxlang.runtime.types.exceptions.BoxRuntimeException;
import ortus.boxlang.web.context.WebRequestBoxContext;
import ortus.boxlang.web.exchange.BoxCookie;
import ortus.boxlang.web.exchange.IBoxHTTPExchange;
import ortus.boxlang.web.util.BlockingBufferedOutputStream;

public class BoxHTTPUndertowExchange
implements IBoxHTTPExchange {
    private Map<String, Object> attributes = new HashMap<String, Object>();
    protected StreamSinkChannel channel = null;
    PrintWriter writer;
    protected HttpServerExchange exchange;
    protected WebRequestBoxContext context;
    List<IBoxHTTPExchange.FileUpload> fileUploads = new ArrayList<IBoxHTTPExchange.FileUpload>();

    public BoxHTTPUndertowExchange(HttpServerExchange exchange) {
        this.exchange = exchange;
    }

    public synchronized StreamSinkChannel getResponseChannel() {
        if (this.channel == null) {
            this.channel = this.exchange.getResponseChannel();
        }
        return this.channel;
    }

    public HttpServerExchange getExchange() {
        return this.exchange;
    }

    @Override
    public void setWebContext(WebRequestBoxContext context) {
        this.context = context;
    }

    @Override
    public WebRequestBoxContext getWebContext() {
        return this.context;
    }

    @Override
    public void forward(String URI2) {
        this.exchange.setRequestPath(URI2);
        this.exchange.setRelativePath(URI2);
        this.exchange.dispatch();
    }

    @Override
    public void addResponseCookie(BoxCookie cookie) {
        if (!this.isResponseStarted()) {
            CookieImpl c = new CookieImpl(cookie.getName(), cookie.getValue());
            if (cookie.getDomain() != null) {
                c.setDomain(cookie.getDomain());
            }
            if (cookie.getPath() != null) {
                c.setPath(cookie.getPath());
            }
            c.setSecure(cookie.isSecure());
            c.setHttpOnly(cookie.isHttpOnly());
            if (cookie.getMaxAge() != null) {
                c.setMaxAge(cookie.getMaxAge());
            }
            c.setSameSite(cookie.isSameSite());
            if (cookie.getExpires() != null) {
                c.setExpires(cookie.getExpires());
            }
            if (cookie.getSameSiteMode() != null) {
                c.setSameSiteMode(cookie.getSameSiteMode());
            }
            this.exchange.setResponseCookie(c);
        }
    }

    @Override
    public void addResponseHeader(String name, String value) {
        this.exchange.getResponseHeaders().put(new HttpString(name), value);
    }

    @Override
    public void flushResponseBuffer() {
        try {
            String contentType = this.getResponseHeader("Content-Type");
            if (contentType == null || contentType.isEmpty()) {
                this.setResponseHeader("Content-Type", "text/html;charset=UTF-8");
            }
            this.writer.flush();
            this.getResponseChannel().flush();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @Override
    public Object getRequestAttribute(String name) {
        return this.attributes.get(name);
    }

    @Override
    public Map<String, Object> getRequestAttributeMap() {
        return this.attributes;
    }

    @Override
    public String getRequestAuthType() {
        SecurityContext securityContext = this.exchange.getSecurityContext();
        return securityContext != null ? securityContext.getMechanismName() : null;
    }

    @Override
    public String getRequestCharacterEncoding() {
        String contentType = this.exchange.getRequestHeaders().getFirst(Headers.CONTENT_TYPE);
        if (contentType == null) {
            return null;
        }
        return Headers.extractQuotedValueFromHeader(contentType, "charset");
    }

    @Override
    public long getRequestContentLength() {
        String contentLength = this.getRequestHeader(Headers.CONTENT_LENGTH);
        if (contentLength == null || contentLength.isEmpty()) {
            return -1L;
        }
        return Long.parseLong(contentLength);
    }

    @Override
    public String getRequestContentType() {
        return this.getRequestHeader(Headers.CONTENT_TYPE);
    }

    @Override
    public String getRequestContextPath() {
        return "";
    }

    @Override
    public BoxCookie[] getRequestCookies() {
        Iterable<Cookie> cookiesIterable = this.exchange.requestCookies();
        ArrayList cookies = new ArrayList();
        cookiesIterable.forEach(cookies::add);
        BoxCookie[] boxCookies = new BoxCookie[cookies.size()];
        for (int i = 0; i < cookies.size(); ++i) {
            Cookie cookie = (Cookie)cookies.get(i);
            BoxCookie c = new BoxCookie(cookie.getName(), cookie.getValue());
            if (cookie.getDomain() != null) {
                c.setDomain(cookie.getDomain());
            }
            if (cookie.getPath() != null) {
                c.setPath(cookie.getPath());
            }
            c.setSecure(cookie.isSecure());
            c.setHttpOnly(cookie.isHttpOnly());
            if (cookie.getMaxAge() != null) {
                c.setMaxAge(cookie.getMaxAge());
            }
            c.setSameSite(cookie.isSameSite());
            if (cookie.getExpires() != null) {
                c.setExpires(cookie.getExpires());
            }
            if (cookie.getSameSiteMode() != null) {
                c.setSameSiteMode(cookie.getSameSiteMode());
            }
            boxCookies[i] = c;
        }
        return boxCookies;
    }

    @Override
    public Map<String, String[]> getRequestHeaderMap() {
        HashMap<String, String[]> headers = new HashMap<String, String[]>();
        this.exchange.getRequestHeaders().forEach(headerValues -> headers.put(headerValues.getHeaderName().toString(), headerValues.toArray(new String[0])));
        return headers;
    }

    @Override
    public String getRequestHeader(String name) {
        return this.exchange.getRequestHeaders().getFirst(name);
    }

    public String getRequestHeader(HttpString name) {
        HeaderMap headers = this.exchange.getRequestHeaders();
        return headers.getFirst(name);
    }

    @Override
    public String getRequestLocalAddr() {
        InetSocketAddress destinationAddress = this.exchange.getDestinationAddress();
        if (destinationAddress == null) {
            return "";
        }
        InetAddress address = destinationAddress.getAddress();
        if (address == null) {
            return destinationAddress.getHostString();
        }
        return address.getHostAddress();
    }

    @Override
    public String getRequestLocalName() {
        return this.exchange.getDestinationAddress().getHostName();
    }

    @Override
    public int getRequestLocalPort() {
        return this.exchange.getDestinationAddress().getPort();
    }

    @Override
    public Locale getRequestLocale() {
        return this.getRequestLocales().nextElement();
    }

    @Override
    public Enumeration<Locale> getRequestLocales() {
        HeaderValues acceptLanguage = this.exchange.getRequestHeaders().get(Headers.ACCEPT_LANGUAGE);
        List<Locale> ret = LocaleUtils.getLocalesFromHeader(acceptLanguage);
        if (ret.isEmpty()) {
            return Collections.enumeration(Collections.singletonList(Locale.getDefault()));
        }
        return Collections.enumeration(ret);
    }

    @Override
    public String getRequestMethod() {
        return this.exchange.getRequestMethod().toString();
    }

    @Override
    public Map<String, String[]> getRequestURLMap() {
        Map<String, Deque<String>> queryParameters = this.exchange.getQueryParameters();
        HashMap<String, String[]> queryParametersArray = new HashMap<String, String[]>();
        for (Map.Entry<String, Deque<String>> entry : queryParameters.entrySet()) {
            String key = entry.getKey();
            Deque<String> valueDeque = entry.getValue();
            String[] valueArray = valueDeque.toArray(new String[0]);
            queryParametersArray.put(key, valueArray);
        }
        return queryParametersArray;
    }

    @Override
    public Map<String, String[]> getRequestFormMap() {
        System.setProperty("io.undertow.multipart.minsize", "0");
        FormParserFactory parserFactory = FormParserFactory.builder().build();
        FormDataParser parser = parserFactory.createParser(this.exchange);
        HashMap<String, String[]> formMap = new HashMap<String, String[]>();
        if (parser != null) {
            FormData formData;
            try {
                formData = parser.parseBlocking();
            }
            catch (IOException e) {
                throw new BoxRuntimeException("Could not parse form data", e);
            }
            for (String key : formData) {
                formMap.put(key, (String[])formData.get(key).stream().map(f -> {
                    if (f.isFileItem()) {
                        Path file = f.getFileItem().getFile();
                        if (file != null) {
                            this.fileUploads.add(new IBoxHTTPExchange.FileUpload(Key.of(key), file, f.getFileName()));
                            return file.toString();
                        }
                        return f.getValue();
                    }
                    return f.getValue();
                }).toArray(String[]::new));
            }
            return formMap;
        }
        return Collections.emptyMap();
    }

    @Override
    public IBoxHTTPExchange.FileUpload[] getUploadData() {
        return this.fileUploads.toArray(new IBoxHTTPExchange.FileUpload[0]);
    }

    @Override
    public String getRequestPathInfo() {
        Map<String, Object> predicateContext = this.exchange.getAttachment(Predicate.PREDICATE_CONTEXT);
        if (predicateContext.containsKey("pathInfo")) {
            return (String)predicateContext.get("pathInfo");
        }
        return "";
    }

    @Override
    public String getRequestPathTranslated() {
        return Path.of(this.getWebContext().getWebRoot(), this.getRequestURI()).toString();
    }

    @Override
    public String getRequestProtocol() {
        return this.exchange.getProtocol().toString();
    }

    @Override
    public String getRequestQueryString() {
        return this.exchange.getQueryString().isEmpty() ? null : this.exchange.getQueryString();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public Object getRequestBody() {
        InputStream inputStream = this.exchange.getInputStream();
        if (inputStream.available() == 0) {
            return "";
        }
        if (!this.isTextBasedContentType()) return inputStream.readAllBytes();
        Scanner scanner = new Scanner(inputStream).useDelimiter("\\A");
        try {
            String string = scanner.next();
            if (scanner == null) return string;
            scanner.close();
            return string;
        }
        catch (Throwable throwable) {
            try {
                if (scanner == null) throw throwable;
                try {
                    scanner.close();
                    throw throwable;
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                e.printStackTrace();
                return "";
            }
        }
    }

    @Override
    public String getRequestRemoteAddr() {
        InetSocketAddress sourceAddress = this.exchange.getSourceAddress();
        if (sourceAddress == null) {
            return "";
        }
        InetAddress address = sourceAddress.getAddress();
        if (address == null) {
            return sourceAddress.getHostString();
        }
        return address.getHostAddress();
    }

    @Override
    public String getRequestRemoteHost() {
        InetSocketAddress sourceAddress = this.exchange.getSourceAddress();
        if (sourceAddress == null) {
            return "";
        }
        return sourceAddress.getHostString();
    }

    @Override
    public int getRequestRemotePort() {
        return this.exchange.getSourceAddress().getPort();
    }

    @Override
    public String getRequestRemoteUser() {
        Principal userPrincipal = this.getRequestUserPrincipal();
        return userPrincipal != null ? userPrincipal.getName() : null;
    }

    @Override
    public String getRequestScheme() {
        return this.exchange.getRequestScheme();
    }

    @Override
    public String getRequestServerName() {
        return this.exchange.getHostName();
    }

    @Override
    public int getRequestServerPort() {
        return this.exchange.getHostPort();
    }

    @Override
    public String getRequestURI() {
        return this.exchange.getRelativePath();
    }

    @Override
    public StringBuffer getRequestURL() {
        return new StringBuffer(this.exchange.getRequestURL());
    }

    @Override
    public Principal getRequestUserPrincipal() {
        SecurityContext securityContext = this.exchange.getSecurityContext();
        Principal result = null;
        Account account = null;
        if (securityContext != null && (account = securityContext.getAuthenticatedAccount()) != null) {
            result = account.getPrincipal();
        }
        return result;
    }

    @Override
    public String getResponseHeader(String name) {
        return this.exchange.getResponseHeaders().getFirst(name);
    }

    @Override
    public Map<String, String[]> getResponseHeaderMap() {
        HashMap<String, String[]> headers = new HashMap<String, String[]>();
        this.exchange.getResponseHeaders().forEach(headerValues -> headers.put(headerValues.getHeaderName().toString(), headerValues.toArray(new String[0])));
        return headers;
    }

    @Override
    public int getResponseStatus() {
        return this.exchange.getStatusCode();
    }

    @Override
    public PrintWriter getResponseWriter() {
        if (this.writer == null) {
            BlockingBufferedOutputStream outputStream = new BlockingBufferedOutputStream(this.getResponseChannel());
            this.writer = new PrintWriter(outputStream, false);
        }
        return this.writer;
    }

    @Override
    public void sendResponseBinary(byte[] data) {
        ByteBuffer bBuffer = ByteBuffer.wrap(data);
        try {
            this.getResponseChannel().write(bBuffer);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @Override
    public void sendResponseFile(File file) {
        try (FileInputStream fis = new FileInputStream(file);){
            FileChannel fileChannel = fis.getChannel();
            this.getResponseChannel().transferFrom(fileChannel, 0L, fileChannel.size());
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @Override
    public boolean isRequestSecure() {
        return this.exchange.isSecure();
    }

    @Override
    public void removeRequestAttribute(String name) {
        this.attributes.remove(name);
    }

    @Override
    public void resetResponseBuffer() {
        this.context.clearBuffer();
    }

    @Override
    public void setRequestAttribute(String name, Object value) {
        this.attributes.put(name, value);
    }

    @Override
    public void setResponseHeader(String name, String value) {
        if (!this.isResponseStarted()) {
            this.exchange.getResponseHeaders().put(new HttpString(name), value);
        }
    }

    @Override
    public void setResponseStatus(int sc) {
        if (!this.isResponseStarted()) {
            this.exchange.setStatusCode(sc);
        }
    }

    @Override
    public void setResponseStatus(int sc, String sm) {
        if (!this.isResponseStarted()) {
            this.exchange.setStatusCode(sc);
            this.exchange.setReasonPhrase(sm);
        }
    }

    @Override
    public BoxCookie getRequestCookie(String name) {
        BoxCookie[] cookies;
        for (BoxCookie cookie : cookies = this.getRequestCookies()) {
            if (!cookie.getName().equalsIgnoreCase(name)) continue;
            return cookie;
        }
        return null;
    }

    @Override
    public boolean isResponseStarted() {
        return this.exchange.isResponseStarted();
    }
}

