/*
 * Decompiled with CFR 0.152.
 */
package ortus.boxlang.web.handlers;

import io.undertow.predicate.Predicate;
import io.undertow.server.HttpHandler;
import io.undertow.server.HttpServerExchange;
import java.io.IOException;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.xnio.ChannelListener;
import org.xnio.ChannelListeners;
import org.xnio.channels.StreamSinkChannel;
import ortus.boxlang.web.WebRequestExecutor;
import ortus.boxlang.web.exchange.BoxHTTPUndertowExchange;

public class BLHandler
implements HttpHandler {
    static final Pattern pattern = Pattern.compile("^(/.+?\\.cfml|/.+?\\.cf[cms]|.+?\\.bx[ms]{0,1})(/.*)?$");
    private String webRoot;

    public BLHandler(String webRoot) {
        this.webRoot = webRoot;
    }

    @Override
    public void handleRequest(HttpServerExchange exchange) throws Exception {
        if (exchange.isInIoThread()) {
            exchange.dispatch(this);
            return;
        }
        exchange.startBlocking();
        this.processPathInfo(exchange);
        BoxHTTPUndertowExchange httpExchange = new BoxHTTPUndertowExchange(exchange);
        WebRequestExecutor.execute(httpExchange, this.webRoot, true);
        this.finalizeResponse(httpExchange);
    }

    private void processPathInfo(HttpServerExchange exchange) {
        String requestPath = exchange.getRequestURI();
        Map<String, Object> predicateContext = exchange.getAttachment(Predicate.PREDICATE_CONTEXT);
        if (!predicateContext.containsKey("pathInfo")) {
            Matcher matcher = pattern.matcher(requestPath);
            if (matcher.find()) {
                String pathInfo = matcher.group(2);
                if (pathInfo != null) {
                    exchange.setRelativePath(matcher.group(1));
                    predicateContext.put("pathInfo", pathInfo);
                } else {
                    predicateContext.put("pathInfo", "");
                }
            } else {
                predicateContext.put("pathInfo", "");
            }
        }
    }

    public void finalizeResponse(final BoxHTTPUndertowExchange httpExchange) {
        StreamSinkChannel channel = httpExchange.getResponseChannel();
        channel.getWriteSetter().set((ChannelListener<? extends StreamSinkChannel>)new ChannelListener<StreamSinkChannel>(){

            @Override
            public void handleEvent(StreamSinkChannel channel) {
                try {
                    channel.shutdownWrites();
                    if (!channel.flush()) {
                        channel.getWriteSetter().set(ChannelListeners.flushingChannelListener(new ChannelListener<StreamSinkChannel>(){

                            @Override
                            public void handleEvent(StreamSinkChannel channel) {
                                try {
                                    if (channel.flush()) {
                                        httpExchange.getExchange().endExchange();
                                    }
                                }
                                catch (IOException e) {
                                    httpExchange.getExchange().endExchange();
                                }
                            }
                        }, ChannelListeners.closingChannelExceptionHandler()));
                        channel.resumeWrites();
                    } else {
                        httpExchange.getExchange().endExchange();
                    }
                }
                catch (IOException e) {
                    httpExchange.getExchange().endExchange();
                }
            }
        });
        channel.resumeWrites();
    }
}

