/*
 * Decompiled with CFR 0.152.
 */
package ortus.boxlang.web.handlers;

import io.undertow.server.HttpHandler;
import io.undertow.server.handlers.PathHandler;
import io.undertow.server.protocol.framed.AbstractFramedChannel;
import io.undertow.websockets.WebSocketConnectionCallback;
import io.undertow.websockets.WebSocketProtocolHandshakeHandler;
import io.undertow.websockets.core.WebSocketChannel;
import io.undertow.websockets.core.WebSockets;
import io.undertow.websockets.core.protocol.Handshake;
import io.undertow.websockets.core.protocol.version07.Hybi07Handshake;
import io.undertow.websockets.core.protocol.version08.Hybi08Handshake;
import io.undertow.websockets.core.protocol.version13.Hybi13Handshake;
import io.undertow.websockets.spi.WebSocketHttpExchange;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import ortus.boxlang.web.MiniServer;
import ortus.boxlang.web.handlers.WebsocketReceiveListener;

public class WebsocketHandler
extends PathHandler {
    private final Set<WebSocketChannel> connections = Collections.synchronizedSet(new HashSet());
    private final WebSocketProtocolHandshakeHandler webSocketProtocolHandshakeHandler;

    public WebsocketHandler(final HttpHandler next, String prefixPath) {
        super(next);
        HashSet<Handshake> handshakes = new HashSet<Handshake>();
        handshakes.add(new Hybi13Handshake(Set.of("v12.stomp", "v11.stomp", "v10.stomp"), false));
        handshakes.add(new Hybi08Handshake(Set.of("v12.stomp", "v11.stomp", "v10.stomp"), false));
        handshakes.add(new Hybi07Handshake(Set.of("v12.stomp", "v11.stomp", "v10.stomp"), false));
        this.webSocketProtocolHandshakeHandler = new WebSocketProtocolHandshakeHandler(handshakes, new WebSocketConnectionCallback(){

            @Override
            public void onConnect(WebSocketHttpExchange WSexchange, WebSocketChannel channel) {
                WebsocketHandler.this.connections.add(channel);
                WebsocketReceiveListener listener = new WebsocketReceiveListener(MiniServer.getCurrentExchange(), next, channel);
                channel.getReceiveSetter().set(listener);
                channel.getCloseSetter().set(c -> {
                    WebsocketHandler.this.connections.remove(channel);
                    listener.onClose((AbstractFramedChannel)c);
                });
                channel.resumeReceives();
            }
        }, next);
        this.addPrefixPath(prefixPath, this.webSocketProtocolHandshakeHandler);
    }

    public Set<WebSocketChannel> getConnections() {
        return this.connections;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendMessage(WebSocketChannel channel, String message) {
        if (channel == null || !channel.isOpen()) {
            return;
        }
        WebSocketChannel webSocketChannel = channel;
        synchronized (webSocketChannel) {
            WebSockets.sendText(message, channel, null);
        }
    }

    public void broadcastMessage(String message) {
        for (WebSocketChannel channel : this.connections) {
            this.sendMessage(channel, message);
        }
    }
}

