/*
 * Decompiled with CFR 0.152.
 */
package ortus.boxlang.web.handlers;

import io.undertow.UndertowMessages;
import io.undertow.connector.ByteBufferPool;
import io.undertow.server.Connectors;
import io.undertow.server.DefaultByteBufferPool;
import io.undertow.server.HttpHandler;
import io.undertow.server.HttpServerExchange;
import io.undertow.server.HttpUpgradeListener;
import io.undertow.server.SSLSessionInfo;
import io.undertow.server.ServerConnection;
import io.undertow.server.XnioBufferPoolAdaptor;
import io.undertow.server.protocol.framed.AbstractFramedChannel;
import io.undertow.util.AttachmentKey;
import io.undertow.util.BadRequestException;
import io.undertow.util.ParameterLimitException;
import io.undertow.websockets.core.AbstractReceiveListener;
import io.undertow.websockets.core.BufferedBinaryMessage;
import io.undertow.websockets.core.BufferedTextMessage;
import io.undertow.websockets.core.WebSocketChannel;
import java.io.IOException;
import java.net.SocketAddress;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.xnio.ChannelListener;
import org.xnio.Option;
import org.xnio.OptionMap;
import org.xnio.Pool;
import org.xnio.Pooled;
import org.xnio.StreamConnection;
import org.xnio.XnioIoThread;
import org.xnio.XnioWorker;
import org.xnio.channels.Configurable;
import org.xnio.channels.ConnectedChannel;
import org.xnio.channels.StreamSinkChannel;
import org.xnio.channels.StreamSourceChannel;
import org.xnio.conduits.ConduitStreamSinkChannel;
import org.xnio.conduits.ConduitStreamSourceChannel;
import org.xnio.conduits.ReadReadyHandler;
import org.xnio.conduits.StreamSinkConduit;
import org.xnio.conduits.StreamSourceConduit;
import org.xnio.conduits.WriteReadyHandler;
import ortus.boxlang.web.MiniServer;

public class WebsocketReceiveListener
extends AbstractReceiveListener {
    public static final AttachmentKey<List<Object>> WEBSOCKET_REQUEST_DETAILS = AttachmentKey.create(List.class);
    private HttpServerExchange initialExchange;
    private HttpHandler next;
    private WebSocketChannel channel;

    public WebsocketReceiveListener(HttpServerExchange exchange, HttpHandler next, WebSocketChannel channel) {
        this.initialExchange = exchange;
        this.next = next;
        this.channel = channel;
        this.dispatchRequest("onConnect", List.of(channel));
    }

    public void onClose(AbstractFramedChannel channel) {
        this.dispatchRequest("onClose", List.of(channel));
    }

    @Override
    protected void onFullTextMessage(WebSocketChannel channel, BufferedTextMessage message) throws IOException {
        this.dispatchRequest("onFullTextMessage", List.of(message.getData(), channel));
    }

    @Override
    protected void onFullBinaryMessage(WebSocketChannel channel, BufferedBinaryMessage message) throws IOException {
        Pooled<ByteBuffer[]> pbb = message.getData();
        ByteBuffer[] bb = pbb.getResource();
        StringBuilder sb = new StringBuilder();
        for (ByteBuffer b : bb) {
            sb.append(new String(b.array(), "UTF-8"));
        }
        this.dispatchRequest("onFullBinaryMessage", List.of(sb.toString(), channel));
        message.getData().free();
    }

    public void dispatchRequest(String method, List<Object> requestDetails) {
        if (MiniServer.shuttingDown) {
            return;
        }
        try {
            String newUri = "/WebSocket.cfc?method=onProcess&WSMethod=" + method;
            DefaultByteBufferPool bufferPool = new DefaultByteBufferPool(false, 1024, 0, 0);
            MockServerConnection connection = new MockServerConnection(bufferPool, this.initialExchange);
            HttpServerExchange newExchange = new HttpServerExchange(connection);
            newExchange.putAttachment(WEBSOCKET_REQUEST_DETAILS, requestDetails);
            this.initialExchange.getRequestHeaders().forEach(header -> {
                if (!header.getHeaderName().toString().equalsIgnoreCase("Upgrade")) {
                    newExchange.getRequestHeaders().add(header.getHeaderName(), header.getFirst());
                }
            });
            newExchange.setRequestMethod(this.initialExchange.getRequestMethod());
            newExchange.setProtocol(this.initialExchange.getProtocol());
            newExchange.setRequestScheme(this.initialExchange.getRequestScheme());
            newExchange.setSourceAddress(this.initialExchange.getSourceAddress());
            newExchange.setDestinationAddress(this.initialExchange.getDestinationAddress());
            StringBuilder sb = new StringBuilder();
            try {
                Connectors.setExchangeRequestPath(newExchange, newUri, sb);
            }
            catch (BadRequestException | ParameterLimitException e) {
                e.printStackTrace();
            }
            newExchange.setRequestURI(this.initialExchange.getRequestScheme() + "://" + this.initialExchange.getHostAndPort() + newUri, true);
            HttpHandler exchangeSetter = new HttpHandler(){

                @Override
                public void handleRequest(HttpServerExchange exchange) throws Exception {
                    try {
                        MiniServer.setCurrentExchange(exchange);
                        WebsocketReceiveListener.this.next.handleRequest(exchange);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                    finally {
                        MiniServer.setCurrentExchange(null);
                    }
                }

                public String toString() {
                    return "Websocket Exchange Setter Handler";
                }
            };
            newExchange.dispatch(exchangeSetter);
        }
        catch (Exception e) {
            System.out.println("Error dispatching websocket request: " + e.getMessage());
            e.printStackTrace();
        }
    }

    private static class MockServerConnection
    extends ServerConnection {
        private final ByteBufferPool bufferPool;
        private SSLSessionInfo sslSessionInfo;
        private XnioBufferPoolAdaptor poolAdaptor;
        private HttpServerExchange initialExchange;

        private MockServerConnection(ByteBufferPool bufferPool, HttpServerExchange initialExchange) {
            this.bufferPool = bufferPool;
            this.initialExchange = initialExchange;
        }

        @Override
        public Pool<ByteBuffer> getBufferPool() {
            if (this.poolAdaptor == null) {
                this.poolAdaptor = new XnioBufferPoolAdaptor(this.getByteBufferPool());
            }
            return this.poolAdaptor;
        }

        @Override
        public ByteBufferPool getByteBufferPool() {
            return this.bufferPool;
        }

        @Override
        public XnioWorker getWorker() {
            return this.initialExchange.getConnection().getWorker();
        }

        @Override
        public XnioIoThread getIoThread() {
            return null;
        }

        @Override
        public HttpServerExchange sendOutOfBandResponse(HttpServerExchange exchange) {
            throw UndertowMessages.MESSAGES.outOfBandResponseNotSupported();
        }

        @Override
        public boolean isContinueResponseSupported() {
            return false;
        }

        @Override
        public void terminateRequestChannel(HttpServerExchange exchange) {
        }

        @Override
        public boolean isOpen() {
            return true;
        }

        @Override
        public boolean supportsOption(Option<?> option) {
            return false;
        }

        @Override
        public <T> T getOption(Option<T> option) throws IOException {
            return null;
        }

        @Override
        public <T> T setOption(Option<T> option, T value) throws IllegalArgumentException, IOException {
            return null;
        }

        @Override
        public void close() throws IOException {
        }

        @Override
        public SocketAddress getPeerAddress() {
            return null;
        }

        @Override
        public <A extends SocketAddress> A getPeerAddress(Class<A> type) {
            return null;
        }

        @Override
        public ChannelListener.Setter<? extends ConnectedChannel> getCloseSetter() {
            return null;
        }

        @Override
        public SocketAddress getLocalAddress() {
            return null;
        }

        @Override
        public <A extends SocketAddress> A getLocalAddress(Class<A> type) {
            return null;
        }

        @Override
        public OptionMap getUndertowOptions() {
            return OptionMap.EMPTY;
        }

        @Override
        public int getBufferSize() {
            return 1024;
        }

        @Override
        public SSLSessionInfo getSslSessionInfo() {
            return this.sslSessionInfo;
        }

        @Override
        public void setSslSessionInfo(SSLSessionInfo sessionInfo) {
            this.sslSessionInfo = sessionInfo;
        }

        @Override
        public void addCloseListener(ServerConnection.CloseListener listener) {
        }

        @Override
        public StreamConnection upgradeChannel() {
            return null;
        }

        @Override
        public ConduitStreamSinkChannel getSinkChannel() {
            return new ConduitStreamSinkChannel(Configurable.EMPTY, new DummyStreamSinkConduit(this.initialExchange));
        }

        @Override
        public ConduitStreamSourceChannel getSourceChannel() {
            return new ConduitStreamSourceChannel(Configurable.EMPTY, new DummyStreamSourceConduit(this.initialExchange));
        }

        @Override
        protected StreamSinkConduit getSinkConduit(HttpServerExchange exchange, StreamSinkConduit conduit) {
            return conduit;
        }

        @Override
        protected boolean isUpgradeSupported() {
            return false;
        }

        @Override
        protected boolean isConnectSupported() {
            return false;
        }

        @Override
        protected void exchangeComplete(HttpServerExchange exchange) {
        }

        @Override
        protected void setUpgradeListener(HttpUpgradeListener upgradeListener) {
        }

        @Override
        protected void setConnectListener(HttpUpgradeListener connectListener) {
        }

        @Override
        protected void maxEntitySizeUpdated(HttpServerExchange exchange) {
        }

        @Override
        public String getTransportProtocol() {
            return "mock";
        }

        @Override
        public boolean isRequestTrailerFieldsSupported() {
            return false;
        }
    }

    private static class DummyStreamSourceConduit
    implements StreamSourceConduit {
        private HttpServerExchange initialExchange;

        public DummyStreamSourceConduit(HttpServerExchange initialExchange) {
            this.initialExchange = initialExchange;
        }

        @Override
        public long transferTo(long position, long count, FileChannel target) throws IOException {
            return 0L;
        }

        @Override
        public long transferTo(long count, ByteBuffer throughBuffer, StreamSinkChannel target) throws IOException {
            return -1L;
        }

        @Override
        public int read(ByteBuffer dst) throws IOException {
            return -1;
        }

        @Override
        public long read(ByteBuffer[] dsts, int offs, int len) throws IOException {
            return -1L;
        }

        @Override
        public void terminateReads() throws IOException {
        }

        @Override
        public boolean isReadShutdown() {
            return true;
        }

        @Override
        public void resumeReads() {
        }

        @Override
        public void suspendReads() {
        }

        @Override
        public void wakeupReads() {
        }

        @Override
        public boolean isReadResumed() {
            return false;
        }

        @Override
        public void awaitReadable() throws IOException {
        }

        @Override
        public void awaitReadable(long time, TimeUnit timeUnit) throws IOException {
        }

        @Override
        public XnioIoThread getReadThread() {
            return null;
        }

        @Override
        public void setReadReadyHandler(ReadReadyHandler handler) {
        }

        @Override
        public XnioWorker getWorker() {
            return this.initialExchange.getConnection().getWorker();
        }
    }

    private static class DummyStreamSinkConduit
    implements StreamSinkConduit {
        private HttpServerExchange initialExchange;

        public DummyStreamSinkConduit(HttpServerExchange initialExchange) {
            this.initialExchange = initialExchange;
        }

        @Override
        public int write(ByteBuffer src) throws IOException {
            int len = src.remaining();
            src.position(src.limit());
            return len;
        }

        @Override
        public long write(ByteBuffer[] srcs, int offset, int length) throws IOException {
            long total = 0L;
            for (int i = offset; i < offset + length; ++i) {
                total += (long)srcs[i].remaining();
                srcs[i].position(srcs[i].limit());
            }
            return total;
        }

        @Override
        public long writeFinal(ByteBuffer[] srcs, int offset, int length) throws IOException {
            long total = 0L;
            for (int i = offset; i < offset + length; ++i) {
                total += (long)srcs[i].remaining();
                srcs[i].position(srcs[i].limit());
            }
            return total;
        }

        @Override
        public long transferFrom(StreamSourceChannel source, long count, ByteBuffer throughBuffer) throws IOException {
            return count;
        }

        @Override
        public int writeFinal(ByteBuffer src) throws IOException {
            int len = src.remaining();
            src.position(src.limit());
            return len;
        }

        @Override
        public XnioIoThread getWriteThread() {
            return null;
        }

        @Override
        public XnioWorker getWorker() {
            return this.initialExchange.getConnection().getWorker();
        }

        @Override
        public long transferFrom(FileChannel src, long position, long count) throws IOException {
            return count;
        }

        @Override
        public void setWriteReadyHandler(WriteReadyHandler handler) {
        }

        @Override
        public boolean flush() throws IOException {
            return true;
        }

        @Override
        public void terminateWrites() throws IOException {
        }

        @Override
        public void truncateWrites() throws IOException {
        }

        @Override
        public boolean isWriteShutdown() {
            return false;
        }

        @Override
        public void resumeWrites() {
        }

        @Override
        public void suspendWrites() {
        }

        @Override
        public void wakeupWrites() {
        }

        @Override
        public boolean isWriteResumed() {
            return false;
        }

        @Override
        public void awaitWritable() throws IOException {
        }

        @Override
        public void awaitWritable(long time, TimeUnit timeUnit) throws IOException {
        }
    }
}

