/*
 * Decompiled with CFR 0.152.
 */
package ortus.boxlang.web.handlers;

import io.undertow.server.HttpHandler;
import io.undertow.server.HttpServerExchange;
import io.undertow.server.handlers.resource.Resource;
import io.undertow.server.handlers.resource.ResourceManager;
import io.undertow.util.CanonicalPathUtils;
import java.io.IOException;
import java.util.List;

public class WelcomeFileHandler
implements HttpHandler {
    private final HttpHandler next;
    private final ResourceManager resourceManager;
    private List<String> welcomeFiles;

    public WelcomeFileHandler(HttpHandler next, ResourceManager resourceManager, List<String> welcomeFiles) {
        this.next = next;
        this.resourceManager = resourceManager;
        this.welcomeFiles = welcomeFiles;
    }

    @Override
    public void handleRequest(HttpServerExchange exchange) throws Exception {
        Resource indexResource;
        Resource resource = this.resourceManager.getResource(this.canonicalize(exchange.getRelativePath()));
        if (resource != null && resource.isDirectory() && (indexResource = this.getIndexFiles(exchange, this.resourceManager, resource.getPath(), this.welcomeFiles)) != null) {
            Object newPath = indexResource.getPath();
            if (!((String)newPath).startsWith("/")) {
                newPath = "/" + (String)newPath;
            }
            exchange.setRelativePath((String)newPath);
        }
        this.next.handleRequest(exchange);
    }

    private Resource getIndexFiles(HttpServerExchange exchange, ResourceManager resourceManager, String base, List<String> possible) throws IOException {
        if (possible == null) {
            return null;
        }
        Object realBase = base.endsWith("/") ? base : base + "/";
        for (String possibility : possible) {
            Resource index = resourceManager.getResource(this.canonicalize((String)realBase + possibility));
            if (index == null) continue;
            return index;
        }
        return null;
    }

    private String canonicalize(String s) {
        return CanonicalPathUtils.canonicalize(s);
    }
}

