/*
 * Decompiled with CFR 0.152.
 */
package ortus.boxlang.web.scopes;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.Set;
import java.util.TreeSet;
import ortus.boxlang.runtime.context.IBoxContext;
import ortus.boxlang.runtime.scopes.BaseScope;
import ortus.boxlang.runtime.scopes.Key;
import ortus.boxlang.runtime.types.exceptions.BoxRuntimeException;
import ortus.boxlang.runtime.types.meta.BoxMeta;
import ortus.boxlang.web.context.WebRequestBoxContext;
import ortus.boxlang.web.exchange.IBoxHTTPExchange;
import ortus.boxlang.web.util.KeyDictionary;

public class CGIScope
extends BaseScope {
    private Set<Key> knownKeys = new TreeSet<Key>(Arrays.asList(Key.auth_password, Key.auth_type, Key.auth_user, KeyDictionary.bx_template_path, Key.cert_cookie, Key.cert_flags, Key.cert_issuer, Key.cert_keysize, Key.cert_secretkeysize, Key.cert_serialnumber, Key.cert_server_issuer, Key.cert_server_subject, Key.cert_subject, Key.cf_template_path, Key.content_length, Key.content_type, Key.context_path, Key.gateway_interface, Key.http_accept_encoding, Key.http_accept_language, Key.http_accept, Key.http_connection, Key.http_cookie, Key.http_host, Key.http_referer, Key.http_user_agent, Key.https_keysize, Key.https_secretkeysize, Key.https_server_issuer, Key.https_server_subject, Key.https, Key.local_addr, Key.local_host, Key.path_info, Key.path_translated, Key.query_string, Key.remote_addr, Key.remote_host, Key.remote_user, Key.request_method, Key.request_url, Key.script_name, Key.server_name, Key.server_port_secure, Key.server_port, Key.server_protocol, Key.server_software, Key.web_server_api));
    public static final Key name = Key.of("cgi");
    protected IBoxHTTPExchange exchange;

    public CGIScope(IBoxHTTPExchange exchange) {
        super(name);
        this.exchange = exchange;
    }

    @Override
    public Object assign(IBoxContext context, Key key, Object value) {
        throw new BoxRuntimeException("Cannot assign to the CGI scope");
    }

    private String getTemplatePath(IBoxContext context) {
        WebRequestBoxContext webContext = context.getParentOfType(WebRequestBoxContext.class);
        String requestURI = this.exchange.getRequestURI();
        if (requestURI == null) {
            return "";
        }
        return Path.of(webContext.getWebRoot() + requestURI, new String[0]).toAbsolutePath().toString();
    }

    @Override
    public Object dereference(IBoxContext context, Key key, Boolean safe) {
        if (key.equals(BoxMeta.key)) {
            return this.getBoxMeta();
        }
        if (key.equals(Key.content_type)) {
            return this.defaultNullToString(this.exchange.getRequestHeader("Content-Type"));
        }
        if (key.equals(Key.content_length)) {
            return this.defaultNullToString(this.exchange.getRequestContentLength());
        }
        if (key.equals(Key.cf_template_path) || key.equals(KeyDictionary.bx_template_path) || key.equals(Key.path_translated)) {
            return this.defaultNullToString(this.getTemplatePath(context));
        }
        if (key.equals(Key.https)) {
            return this.defaultNullToString(this.exchange.isRequestSecure());
        }
        if (key.equals(Key.http_host)) {
            int port = this.exchange.getRequestServerPort();
            return port == 80 || port == 443 ? this.exchange.getRequestServerName() : this.exchange.getRequestServerName() + ":" + String.valueOf(this.defaultNullToString(port));
        }
        if (key.equals(Key.local_addr)) {
            try {
                return this.defaultNullToString(InetAddress.getLocalHost().getHostAddress());
            }
            catch (UnknownHostException e) {
                return "127.0.0.1";
            }
        }
        if (key.equals(Key.local_host)) {
            try {
                return this.defaultNullToString(InetAddress.getLocalHost().getHostName());
            }
            catch (UnknownHostException e) {
                return "localhost";
            }
        }
        if (key.equals(Key.request_url)) {
            return this.defaultNullToString(this.exchange.getRequestURL());
        }
        if (key.equals(Key.remote_addr)) {
            return this.defaultNullToString(this.exchange.getRequestRemoteAddr());
        }
        if (key.equals(Key.remote_host)) {
            return this.defaultNullToString(this.exchange.getRequestRemoteHost());
        }
        if (key.equals(Key.remote_user)) {
            return this.defaultNullToString(this.exchange.getRequestRemoteUser());
        }
        if (key.equals(Key.path_info)) {
            return this.defaultNullToString(this.exchange.getRequestPathInfo());
        }
        if (key.equals(Key.query_string)) {
            return this.defaultNullToString(this.exchange.getRequestQueryString());
        }
        if (key.equals(Key.request_method)) {
            return this.defaultNullToString(this.exchange.getRequestMethod());
        }
        if (key.equals(Key.script_name)) {
            return this.defaultNullToString(this.exchange.getRequestURI());
        }
        if (key.equals(Key.server_name)) {
            return this.defaultNullToString(this.exchange.getRequestServerName());
        }
        if (key.equals(Key.server_port)) {
            return this.defaultNullToString(this.exchange.getRequestServerPort());
        }
        if (key.equals(Key.server_port_secure)) {
            return this.exchange.isRequestSecure() ? this.defaultNullToString(this.exchange.getRequestServerPort()) : Integer.valueOf(0);
        }
        if (key.equals(Key.server_protocol)) {
            return this.defaultNullToString(this.exchange.getRequestProtocol());
        }
        String header = this.exchange.getRequestHeader(key.getName());
        if (header != null) {
            return header;
        }
        if (key.getName().toLowerCase().startsWith("http") && (header = this.exchange.getRequestHeader(key.getName().substring(5).replace("_", "-"))) != null) {
            return header;
        }
        return "";
    }

    public Set<Key> getDumpKeys() {
        return this.knownKeys;
    }

    public Set<String> getDumpKeysAsString() {
        return this.knownKeys.stream().map(Key::getName).collect(TreeSet::new, Set::add, Set::addAll);
    }

    private Object defaultNullToString(Object value) {
        return value == null ? "" : value;
    }
}

