/*
 * Decompiled with CFR 0.152.
 */
package ortus.boxlang.web.scopes;

import java.util.AbstractMap;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import ortus.boxlang.runtime.scopes.BaseScope;
import ortus.boxlang.runtime.scopes.Key;
import ortus.boxlang.runtime.types.NullValue;
import ortus.boxlang.web.exchange.IBoxHTTPExchange;

public class RequestScope
extends BaseScope {
    public static final Key name = Key.of("request");
    protected IBoxHTTPExchange exchange;

    public RequestScope(IBoxHTTPExchange exchange) {
        super(name);
        this.exchange = exchange;
    }

    @Override
    public int size() {
        return this.wrapped.size() + this.exchange.getRequestAttributeMap().size();
    }

    @Override
    public boolean isEmpty() {
        return this.wrapped.isEmpty() && this.exchange.getRequestAttributeMap().isEmpty();
    }

    @Override
    public boolean containsKey(Key key) {
        return this.wrapped.containsKey(key) || this.exchange.getRequestAttributeMap().containsKey(key.getName());
    }

    @Override
    public boolean containsValue(Object value) {
        return this.wrapped.containsValue(value) || this.exchange.getRequestAttributeMap().containsValue(value);
    }

    @Override
    public Object getRaw(Key key) {
        Object value = this.wrapped.get(key);
        if (value != null) {
            return value;
        }
        Map<String, Object> requestAttributes = this.exchange.getRequestAttributeMap();
        if (requestAttributes.containsKey(key.getName())) {
            value = requestAttributes.get(key.getName());
            if (value != null) {
                return value;
            }
            return new NullValue();
        }
        return null;
    }

    @Override
    public Set<Key> keySet() {
        HashSet<Key> keys = new HashSet<Key>(this.wrapped.keySet());
        keys.addAll(this.exchange.getRequestAttributeMap().keySet().stream().map(Key::of).collect(Collectors.toSet()));
        return keys;
    }

    @Override
    public Collection<Object> values() {
        List<Object> vals = this.wrapped.values().stream().map(entry -> RequestScope.unWrapNull(entry)).collect(Collectors.toList());
        vals.addAll(this.exchange.getRequestAttributeMap().values());
        return vals;
    }

    @Override
    public Set<Map.Entry<Key, Object>> entrySet() {
        Set entries = this.wrapped.entrySet().stream().map(entry -> new AbstractMap.SimpleEntry<Key, Object>((Key)entry.getKey(), RequestScope.unWrapNull(entry.getValue()))).collect(Collectors.toCollection(LinkedHashSet::new));
        this.exchange.getRequestAttributeMap().entrySet().stream().map(entry -> new AbstractMap.SimpleEntry(Key.of((String)entry.getKey()), entry.getValue())).forEach(entries::add);
        return entries;
    }
}

