/*
 * Decompiled with CFR 0.152.
 */
package ortus.boxlang.web.util;

import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import org.xnio.channels.StreamSinkChannel;

public class BlockingBufferedOutputStream
extends OutputStream {
    private final StreamSinkChannel channel;
    private final ByteBuffer buffer;

    public BlockingBufferedOutputStream(StreamSinkChannel channel) {
        this.channel = channel;
        this.buffer = ByteBuffer.allocate(1024);
    }

    @Override
    public void write(int b) throws IOException {
        this.buffer.put((byte)b);
        this.flushBuffer();
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        int toWrite;
        for (int remaining = len; remaining > 0; remaining -= toWrite) {
            toWrite = Math.min(this.buffer.remaining(), remaining);
            this.buffer.put(b, off + (len - remaining), toWrite);
            this.flushBuffer();
        }
    }

    private void flushBuffer() throws IOException {
        if (this.channel == null) {
            this.buffer.clear();
            return;
        }
        this.buffer.flip();
        while (this.buffer.hasRemaining()) {
            this.channel.awaitWritable();
            this.channel.write(this.buffer);
        }
        this.buffer.compact();
    }

    @Override
    public void flush() throws IOException {
        this.flushBuffer();
    }

    @Override
    public void close() throws IOException {
        this.flush();
        if (this.channel == null) {
            return;
        }
        this.channel.close();
    }
}

