/*
 * Decompiled with CFR 0.152.
 */
package brooklyn.rest.domain;

import brooklyn.rest.domain.ApiError;
import com.yammer.dropwizard.testing.JsonHelpers;
import java.io.IOException;
import org.testng.Assert;
import org.testng.annotations.Test;
import org.testng.util.Strings;

public class ApiErrorTest {
    @Test
    public void testSerializeApiError() throws IOException {
        ApiError error = ApiError.builder().message("explanatory message").details("accompanying details").build();
        Assert.assertEquals((String)JsonHelpers.asJson((Object)error), (String)JsonHelpers.jsonFixture((String)"fixtures/api-error-basic.json"));
    }

    @Test
    public void testSerializeApiErrorFromThrowable() throws IOException {
        Exception e = new Exception("error");
        e.setStackTrace(Thread.currentThread().getStackTrace());
        ApiError error = ApiError.fromThrowable((Throwable)e).build();
        ApiError deserialised = (ApiError)JsonHelpers.fromJson((String)JsonHelpers.asJson((Object)error), ApiError.class);
        Assert.assertFalse((boolean)Strings.isNullOrEmpty((String)deserialised.getDetails()), (String)"Expected details to contain exception stack trace");
        Assert.assertEquals((Object)deserialised, (Object)error);
    }

    @Test
    public void testSerializeApiErrorWithoutDetails() throws IOException {
        ApiError error = ApiError.builder().message("explanatory message").build();
        Assert.assertEquals((String)JsonHelpers.asJson((Object)error), (String)JsonHelpers.jsonFixture((String)"fixtures/api-error-no-details.json"));
    }
}

