/*
 * Decompiled with CFR 0.152.
 */
package brooklyn.rest.domain;

import brooklyn.rest.domain.EntitySummary;
import com.google.common.collect.Maps;
import com.yammer.dropwizard.testing.JsonHelpers;
import java.io.IOException;
import java.net.URI;
import java.util.Map;
import org.testng.Assert;
import org.testng.annotations.Test;

public class EntitySummaryTest {
    static final Map<String, URI> links = Maps.newLinkedHashMap();
    static final EntitySummary entitySummary;

    static {
        links.put("self", URI.create("/v1/applications/tesr/entities/zQsqdXzi"));
        links.put("catalog", URI.create("/v1/catalog/entities/brooklyn.entity.webapp.tomcat.TomcatServer"));
        links.put("application", URI.create("/v1/applications/tesr"));
        links.put("children", URI.create("/v1/applications/tesr/entities/zQsqdXzi/entities"));
        links.put("effectors", URI.create("fixtures/effector-summary-list.json"));
        links.put("sensors", URI.create("fixtures/sensor-summary-list.json"));
        links.put("activities", URI.create("fixtures/task-summary-list.json"));
        entitySummary = new EntitySummary("zQsqdXzi", "MyTomcat", "brooklyn.entity.webapp.tomcat.TomcatServer", links);
    }

    @Test
    public void testSerializeToJSON() throws IOException {
        Assert.assertEquals((String)JsonHelpers.asJson((Object)entitySummary), (String)JsonHelpers.jsonFixture((String)"fixtures/entity-summary.json"));
    }

    @Test
    public void testDeserializeFromJSON() throws IOException {
        Assert.assertEquals((Object)JsonHelpers.fromJson((String)JsonHelpers.jsonFixture((String)"fixtures/entity-summary.json"), EntitySummary.class), (Object)entitySummary);
    }
}

