/*
 * Decompiled with CFR 0.152.
 */
package brooklyn.rest.apidoc;

import brooklyn.rest.apidoc.Apidoc;
import brooklyn.rest.apidoc.ApidocEndpoint;
import com.sun.jersey.api.core.ResourceConfig;
import com.wordnik.swagger.core.Api;
import com.wordnik.swagger.core.ApiOperation;
import com.wordnik.swagger.core.Documentation;
import com.wordnik.swagger.core.DocumentationEndPoint;
import com.wordnik.swagger.jaxrs.ConfigReader;
import com.wordnik.swagger.jaxrs.HelpApi;
import com.wordnik.swagger.jaxrs.JaxrsApiReader;
import com.wordnik.swagger.jaxrs.JaxrsApiSpecParser;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;

@Produces(value={"application/json"})
public abstract class ApidocResource {
    static ConfigReader configReader;
    protected static Map<Class<?>, Documentation> endpointsCache;

    static {
        JaxrsApiReader.setFormatString((String)"");
        endpointsCache = new LinkedHashMap();
    }

    protected boolean isSupportedMediaType(String type) {
        if ("application/json".equals(type)) {
            return true;
        }
        return "application/xml".equals(type);
    }

    protected boolean isIncludedForDocumentation(Class<?> resource) {
        Produces produces = resource.getAnnotation(Produces.class);
        if (produces == null) {
            return false;
        }
        String[] stringArray = produces.value();
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String type = stringArray[n2];
            if (this.isSupportedMediaType(type)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    protected String getLinkFor(String path, Class<?> resource) {
        return String.valueOf(this.getClass().getAnnotation(Path.class).value()) + "/" + this.getLinkWordFor(resource);
    }

    protected String getLinkWordFor(Class<?> resource) {
        if (resource.getCanonicalName() != null) {
            return resource.getCanonicalName();
        }
        return Integer.toHexString(resource.hashCode());
    }

    protected Class<?> getResourceOfLink(ResourceConfig rc, String link) {
        for (Class<?> r : this.getResourceClasses(rc)) {
            if (!this.getLinkWordFor(r).equals(link)) continue;
            return r;
        }
        return null;
    }

    @GET
    @ApiOperation(value="Returns list of all available API resource endpoints", responseClass="DocumentationEndPoint", multiValueResponse=true)
    public Response getAllApis(@Context ResourceConfig rc, @Context HttpHeaders headers, @Context UriInfo uriInfo) {
        String apiVersion = this.getConfigReader().getApiVersion();
        String swaggerVersion = this.getConfigReader().getSwaggerVersion();
        String basePath = this.getConfigReader().getBasePath();
        Set<Class<?>> resources = this.getResourceClasses(rc);
        Documentation allApiDoc = new Documentation();
        ArrayList<ApidocEndpoint> endpoints = new ArrayList<ApidocEndpoint>();
        for (Class<?> resource : resources) {
            String description;
            if (!this.isIncludedForDocumentation(resource)) continue;
            Apidoc apidoc = resource.getAnnotation(Apidoc.class);
            Api apidocX = resource.getAnnotation(Api.class);
            Path rsPath = resource.getAnnotation(Path.class);
            if (apidoc == null && apidocX == null) continue;
            String path = rsPath.value();
            String name = null;
            if (apidoc != null) {
                name = apidoc.value();
                description = apidoc.description();
            } else {
                path = apidocX.value();
                description = apidocX.description();
            }
            endpoints.add(new ApidocEndpoint(name, path, description, this.getLinkFor(path, resource)));
        }
        Collections.sort(endpoints, ApidocEndpoint.COMPARATOR);
        for (ApidocEndpoint api : endpoints) {
            if (this.isApiAdded(allApiDoc, api)) continue;
            allApiDoc.addApi((DocumentationEndPoint)api);
        }
        allApiDoc.setSwaggerVersion(swaggerVersion);
        allApiDoc.setBasePath(basePath);
        allApiDoc.setApiVersion(apiVersion);
        return Response.ok().entity((Object)allApiDoc).build();
    }

    protected Set<Class<?>> getResourceClasses(ResourceConfig rc) {
        Set resourceClasses = rc.getRootResourceClasses();
        Set resourceObjects = rc.getRootResourceSingletons();
        LinkedHashSet resources = new LinkedHashSet();
        for (Class<Object> r : resourceClasses) {
            if (r.getAnnotation(Path.class) == null) continue;
            resources.add(r);
        }
        for (Class<Object> r : resourceObjects) {
            if (r.getClass().getAnnotation(Path.class) == null) continue;
            resources.add(r.getClass());
        }
        return resources;
    }

    private boolean isApiAdded(Documentation allApiDoc, DocumentationEndPoint endpoint) {
        boolean isAdded = false;
        if (allApiDoc.getApis() != null) {
            for (DocumentationEndPoint addedApi : allApiDoc.getApis()) {
                if (!endpoint.getPath().equals(addedApi.getPath())) continue;
                isAdded = true;
            }
        }
        return isAdded;
    }

    @GET
    @Path(value="/{resource}")
    public Response details(@Context ResourceConfig rc, @Context HttpHeaders headers, @Context UriInfo uriInfo, @PathParam(value="resource") String resource) {
        Class<?> target = this.getResourceOfLink(rc, resource);
        if (target == null) {
            return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
        }
        String apiVersion = this.getConfigReader().getApiVersion();
        String swaggerVersion = this.getConfigReader().getSwaggerVersion();
        String basePath = this.getConfigReader().getBasePath();
        String apiFilterClassName = this.getConfigReader().getApiFilterClassName();
        Apidoc apidoc = target.getAnnotation(Apidoc.class);
        Api apidocX = target.getAnnotation(Api.class);
        Path rsPath = target.getAnnotation(Path.class);
        if (apidoc == null && apidocX == null || rsPath == null) {
            return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
        }
        String apiPath = apidoc != null ? rsPath.value() : apidocX.value();
        HelpApi helpApi = new HelpApi(apiFilterClassName);
        Documentation doc = this.read(target, apiVersion, swaggerVersion, basePath, apiPath);
        Documentation docs = helpApi.filterDocs(doc, headers, uriInfo, apiPath, apiPath);
        return Response.ok().entity((Object)docs).build();
    }

    protected ConfigReader getConfigReader() {
        if (configReader == null) {
            configReader = new ConfigReader(null);
        }
        return configReader;
    }

    protected Documentation read(Class<?> target, String apiVersion, String swaggerVersion, String basePath, String apiPath) {
        Documentation result = endpointsCache.get(target);
        if (result != null) {
            return result;
        }
        ApidocJaxrsSpecParser parser = new ApidocJaxrsSpecParser(target, apiVersion, swaggerVersion, basePath, apiPath);
        result = parser.parse();
        endpointsCache.put(target, result);
        return result;
    }

    @Api(value="ignored")
    static class ApidocJaxrsSpecParser
    extends JaxrsApiSpecParser {
        public ApidocJaxrsSpecParser(Class<?> target, String apiVersion, String swaggerVersion, String basePath, String apiPath) {
            super(target, apiVersion, swaggerVersion, basePath, apiPath);
        }

        public Api apiEndpoint() {
            return ApidocJaxrsSpecParser.class.getAnnotation(Api.class);
        }

        public String getPath(Method method) {
            Path cwsPath = this.hostClass().getAnnotation(Path.class);
            Path mwsPath = method.getAnnotation(Path.class);
            if (cwsPath == null) {
                return null;
            }
            return String.valueOf(cwsPath.value()) + (mwsPath != null ? mwsPath.value() : "");
        }
    }
}

