/*
 * Decompiled with CFR 0.152.
 */
package brooklyn.rest.domain;

import brooklyn.entity.Application;
import brooklyn.entity.Entity;
import brooklyn.location.Location;
import brooklyn.rest.domain.EntitySpec;
import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.collect.Collections2;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;
import org.codehaus.jackson.annotate.JsonProperty;
import org.codehaus.jackson.map.annotate.JsonSerialize;

public class ApplicationSpec {
    private final String name;
    @JsonSerialize(include=JsonSerialize.Inclusion.NON_NULL)
    private final String type;
    @JsonSerialize(include=JsonSerialize.Inclusion.NON_NULL)
    private final Set<EntitySpec> entities;
    private final Set<String> locations;
    @JsonSerialize(include=JsonSerialize.Inclusion.NON_EMPTY)
    private final Map<String, String> config;

    public static Builder builder() {
        return new Builder();
    }

    public ApplicationSpec(@JsonProperty(value="name") String name, @JsonProperty(value="type") String type, @JsonProperty(value="entities") Set<EntitySpec> entities, @JsonProperty(value="locations") Collection<String> locations, @JsonProperty(value="config") Map<String, String> config) {
        this.name = name;
        this.type = type;
        this.entities = entities == null ? null : (entities.isEmpty() && type != null ? null : ImmutableSet.copyOf(entities));
        this.locations = ImmutableSet.copyOf((Collection)((Collection)Preconditions.checkNotNull(locations, (Object)"locations must be provided for an application spec")));
        ImmutableMap immutableMap = this.config = config == null ? Collections.emptyMap() : ImmutableMap.copyOf(config);
        if (this.entities != null && this.type != null) {
            throw new IllegalStateException("cannot supply both type and entities for an application spec");
        }
    }

    public static ApplicationSpec fromApplication(Application application) {
        Collection locations = Collections2.transform((Collection)application.getLocations(), (Function)new Function<Location, String>(){

            @Nullable
            public String apply(@Nullable Location input) {
                return input.getId();
            }
        });
        return new ApplicationSpec(application.getDisplayName(), application.getEntityType().getName(), null, locations, null);
    }

    public String getName() {
        return this.name;
    }

    public String getType() {
        return this.type;
    }

    public Set<EntitySpec> getEntities() {
        return this.entities;
    }

    public Set<String> getLocations() {
        return this.locations;
    }

    public Map<String, String> getConfig() {
        return this.config;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ApplicationSpec that = (ApplicationSpec)o;
        if (this.name != null ? !this.name.equals(that.name) : that.name != null) {
            return false;
        }
        if (this.type != null ? !this.type.equals(that.type) : that.type != null) {
            return false;
        }
        if (this.entities != null ? !this.entities.equals(that.entities) : that.entities != null) {
            return false;
        }
        if (this.locations != null ? !this.locations.equals(that.locations) : that.locations != null) {
            return false;
        }
        return !(this.config != null ? !this.config.equals(that.config) : that.config != null);
    }

    public int hashCode() {
        int result = this.name != null ? this.name.hashCode() : 0;
        result = 31 * result + (this.type != null ? this.type.hashCode() : 0);
        result = 31 * result + (this.entities != null ? this.entities.hashCode() : 0);
        result = 31 * result + (this.locations != null ? this.locations.hashCode() : 0);
        result = 31 * result + (this.config != null ? this.config.hashCode() : 0);
        return result;
    }

    public String toString() {
        return "ApplicationSpec{name='" + this.name + '\'' + ", type=" + this.type + ", entitySpecs=" + this.entities + ", locations=" + this.locations + ", config=" + this.config + '}';
    }

    public static class Builder {
        private String name;
        private String type;
        private Set<EntitySpec> entities;
        private Set<String> locations;
        private Map<String, String> config;

        public Builder from(ApplicationSpec spec) {
            this.name = spec.name;
            this.entities = spec.entities;
            this.locations = spec.locations;
            return this;
        }

        public Builder name(String name) {
            this.name = name;
            return this;
        }

        public Builder type(Class<? extends Entity> type) {
            this.type = type.getName();
            return this;
        }

        public Builder type(String type) {
            this.type = type;
            return this;
        }

        public Builder entities(Set<EntitySpec> entities) {
            this.entities = entities;
            return this;
        }

        public Builder locations(Set<String> locations) {
            this.locations = locations;
            return this;
        }

        public Builder config(Map<String, String> config) {
            this.config = config;
            return this;
        }

        public ApplicationSpec build() {
            return new ApplicationSpec(this.name, this.type, this.entities, this.locations, this.config);
        }
    }
}

