/*
 * Decompiled with CFR 0.152.
 */
package brooklyn.rest.domain;

import brooklyn.entity.Application;
import brooklyn.entity.basic.Attributes;
import brooklyn.entity.basic.Lifecycle;
import brooklyn.entity.trait.Startable;
import brooklyn.event.AttributeSensor;
import brooklyn.rest.domain.ApplicationSpec;
import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.net.URI;
import java.util.Collections;
import java.util.Map;
import org.codehaus.jackson.annotate.JsonIgnore;
import org.codehaus.jackson.annotate.JsonProperty;

public class ApplicationSummary {
    private static final Map<Status, Status> validTransitions = ImmutableMap.builder().put((Object)Status.UNKNOWN, (Object)Status.ACCEPTED).put((Object)Status.ACCEPTED, (Object)Status.STARTING).put((Object)Status.STARTING, (Object)Status.RUNNING).put((Object)Status.RUNNING, (Object)Status.STOPPING).put((Object)Status.STOPPING, (Object)Status.STOPPED).put((Object)Status.STOPPED, (Object)Status.STARTING).build();
    public static final Function<? super Application, ApplicationSummary> FROM_APPLICATION = new Function<Application, ApplicationSummary>(){

        public ApplicationSummary apply(Application input) {
            return ApplicationSummary.fromApplication(input);
        }
    };
    private final ApplicationSpec spec;
    private final Status status;
    @JsonIgnore
    private transient Application instance;

    public ApplicationSummary(@JsonProperty(value="spec") ApplicationSpec spec, @JsonProperty(value="status") Status status) {
        this.spec = (ApplicationSpec)Preconditions.checkNotNull((Object)spec, (Object)"spec");
        this.status = (Status)((Object)Preconditions.checkNotNull((Object)((Object)status), (Object)"status"));
    }

    public ApplicationSummary(ApplicationSpec spec, Status status, Application instance) {
        this.spec = (ApplicationSpec)Preconditions.checkNotNull((Object)spec, (Object)"spec");
        this.status = (Status)((Object)Preconditions.checkNotNull((Object)((Object)status), (Object)"status"));
        this.instance = instance;
    }

    public static ApplicationSummary fromApplication(Application application) {
        return new ApplicationSummary(ApplicationSpec.fromApplication(application), Status.fromApplication(application), application);
    }

    public ApplicationSpec getSpec() {
        return this.spec;
    }

    @JsonIgnore
    public Object getId() {
        return this.instance.getId();
    }

    @JsonIgnore
    public Application getInstance() {
        return this.instance;
    }

    public Status getStatus() {
        return this.status;
    }

    private void setLinks(Map<String, URI> _) {
    }

    public Map<String, URI> getLinks() {
        if (this.getId() == null) {
            return Collections.emptyMap();
        }
        return ImmutableMap.of((Object)"self", (Object)URI.create("/v1/applications/" + this.getId()), (Object)"entities", (Object)URI.create("/v1/applications/" + this.getId() + "/entities"));
    }

    public ApplicationSummary transitionTo(Status newStatus) {
        if (newStatus == Status.ERROR || validTransitions.get((Object)this.status) == newStatus) {
            return new ApplicationSummary(this.spec, newStatus, this.instance);
        }
        throw new IllegalStateException("Invalid transition from '" + (Object)((Object)this.status) + "' to '" + (Object)((Object)newStatus) + "'");
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ApplicationSummary that = (ApplicationSummary)o;
        if (this.spec != null ? !this.spec.equals(that.spec) : that.spec != null) {
            return false;
        }
        return this.status == that.status;
    }

    public int hashCode() {
        int result = this.spec != null ? this.spec.hashCode() : 0;
        result = 31 * result + (this.status != null ? this.status.hashCode() : 0);
        return result;
    }

    public String toString() {
        return "Application{spec=" + this.spec + ", status=" + (Object)((Object)this.status) + ", instance=" + this.instance + '}';
    }

    public static enum Status {
        ACCEPTED,
        STARTING,
        RUNNING,
        STOPPING,
        STOPPED,
        ERROR,
        UNKNOWN;


        public static Status fromApplication(Application application) {
            if (application == null) {
                return UNKNOWN;
            }
            Lifecycle state = (Lifecycle)application.getAttribute((AttributeSensor)Attributes.SERVICE_STATE);
            if (state != null) {
                return Status.fromLifecycle(state);
            }
            Boolean up = (Boolean)application.getAttribute(Startable.SERVICE_UP);
            if (up != null && up.booleanValue()) {
                return RUNNING;
            }
            return UNKNOWN;
        }

        public static Status fromLifecycle(Lifecycle state) {
            if (state == null) {
                return UNKNOWN;
            }
            switch (state) {
                case CREATED: {
                    return ACCEPTED;
                }
                case STARTING: {
                    return STARTING;
                }
                case RUNNING: {
                    return RUNNING;
                }
                case STOPPING: {
                    return STOPPING;
                }
                case STOPPED: {
                    return STOPPED;
                }
            }
            return UNKNOWN;
        }
    }
}

