/*
 * Decompiled with CFR 0.152.
 */
package brooklyn.rest.domain;

import brooklyn.catalog.CatalogItem;
import brooklyn.config.ConfigKey;
import brooklyn.entity.Entity;
import brooklyn.entity.EntityType;
import brooklyn.entity.basic.EntityDynamicType;
import brooklyn.entity.basic.EntityTypes;
import brooklyn.rest.domain.CatalogItemSummary;
import brooklyn.rest.domain.EffectorSummary;
import brooklyn.rest.domain.EntityConfigSummary;
import brooklyn.rest.domain.SensorSummary;
import brooklyn.rest.util.BrooklynRestResourceUtils;
import com.google.common.collect.Sets;
import java.net.URI;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.codehaus.jackson.annotate.JsonProperty;

public class CatalogEntitySummary
extends CatalogItemSummary {
    private final Set<EntityConfigSummary> config;
    private final Set<SensorSummary> sensors;
    private final Set<EffectorSummary> effectors;

    public CatalogEntitySummary(@JsonProperty(value="id") String id, @JsonProperty(value="name") String name, @JsonProperty(value="type") String type, @JsonProperty(value="description") String description, @JsonProperty(value="iconUrl") String iconUrl, @JsonProperty(value="config") Set<EntityConfigSummary> config, @JsonProperty(value="sensors") Set<SensorSummary> sensors, @JsonProperty(value="effectors") Set<EffectorSummary> effectors, @JsonProperty(value="links") Map<String, URI> links) {
        super(id, name, type, description, iconUrl, links);
        this.config = config;
        this.sensors = sensors;
        this.effectors = effectors;
    }

    public static CatalogEntitySummary from(BrooklynRestResourceUtils b, CatalogItem<? extends Entity> item) {
        Class clazz = b.getCatalog().loadClass(item);
        EntityDynamicType typeMap = EntityTypes.getDefinedEntityType((Class)clazz);
        EntityType type = typeMap.getSnapshot();
        LinkedHashSet config = Sets.newLinkedHashSet();
        LinkedHashSet sensors = Sets.newLinkedHashSet();
        LinkedHashSet effectors = Sets.newLinkedHashSet();
        for (ConfigKey x : type.getConfigKeys()) {
            config.add(EntityConfigSummary.forCatalog(x, typeMap.getConfigKeyField(x.getName())));
        }
        for (ConfigKey x : type.getSensors()) {
            sensors.add(SensorSummary.forCatalog(x));
        }
        for (ConfigKey x : type.getEffectors()) {
            effectors.add(EffectorSummary.forCatalog(x));
        }
        return new CatalogEntitySummary(item.getId(), item.getName(), item.getJavaType(), item.getDescription(), item.getIconUrl(), config, sensors, effectors, CatalogEntitySummary.makeLinks(item));
    }

    public Set<EntityConfigSummary> getConfig() {
        return this.config;
    }

    public Set<SensorSummary> getSensors() {
        return this.sensors;
    }

    public Set<EffectorSummary> getEffectors() {
        return this.effectors;
    }

    @Override
    public String toString() {
        return String.valueOf(super.toString()) + "[" + "config=" + this.getConfig() + "; " + "sensors=" + this.getSensors() + "; " + "effectors=" + this.getEffectors() + "]";
    }
}

