/*
 * Decompiled with CFR 0.152.
 */
package brooklyn.rest.domain;

import brooklyn.catalog.CatalogItem;
import brooklyn.util.MutableMap;
import com.google.common.base.Objects;
import com.google.common.collect.ImmutableMap;
import java.net.URI;
import java.util.Map;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.codehaus.jackson.annotate.JsonProperty;
import org.codehaus.jackson.map.annotate.JsonSerialize;

public class CatalogItemSummary {
    private final String id;
    private final String type;
    private final String name;
    @JsonSerialize(include=JsonSerialize.Inclusion.NON_EMPTY)
    private final String description;
    @JsonSerialize(include=JsonSerialize.Inclusion.NON_EMPTY)
    private final String iconUrl;
    private final Map<String, URI> links;

    public CatalogItemSummary(@JsonProperty(value="id") String id, @JsonProperty(value="name") String name, @JsonProperty(value="type") String type, @JsonProperty(value="description") String description, @JsonProperty(value="iconUrl") String iconUrl, @JsonProperty(value="links") Map<String, URI> links) {
        this.id = id;
        this.name = name;
        this.type = type;
        this.description = description;
        this.iconUrl = iconUrl;
        this.links = ImmutableMap.copyOf(links);
    }

    public static CatalogItemSummary from(CatalogItem<?> item) {
        return new CatalogItemSummary(item.getId(), item.getName(), item.getJavaType(), item.getDescription(), item.getIconUrl(), CatalogItemSummary.makeLinks(item));
    }

    protected static Map<String, URI> makeLinks(CatalogItem<?> item) {
        return MutableMap.of();
    }

    public String getId() {
        return this.id;
    }

    public String getType() {
        return this.type;
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public String getIconUrl() {
        return this.iconUrl;
    }

    public Map<String, URI> getLinks() {
        return this.links;
    }

    public String toString() {
        return Objects.toStringHelper((Object)this).add("id", (Object)this.id).toString();
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.id, this.name, this.type});
    }

    public boolean equals(Object obj) {
        return EqualsBuilder.reflectionEquals((Object)this, (Object)obj);
    }
}

