/*
 * Decompiled with CFR 0.152.
 */
package brooklyn.rest.domain;

import brooklyn.config.ConfigKey;
import java.net.URI;
import java.util.Map;
import org.codehaus.jackson.annotate.JsonProperty;
import org.codehaus.jackson.map.annotate.JsonSerialize;

public abstract class ConfigSummary {
    private final String name;
    private final String type;
    @JsonSerialize(include=JsonSerialize.Inclusion.NON_NULL)
    private final Object defaultValue;
    @JsonSerialize(include=JsonSerialize.Inclusion.NON_NULL)
    private final String description;
    @JsonSerialize
    private final boolean reconfigurable;
    @JsonSerialize(include=JsonSerialize.Inclusion.NON_NULL)
    private final String label;
    @JsonSerialize(include=JsonSerialize.Inclusion.NON_NULL)
    private final Double priority;

    protected ConfigSummary(@JsonProperty(value="name") String name, @JsonProperty(value="type") String type, @JsonProperty(value="description") String description, @JsonProperty(value="defaultValue") Object defaultValue, @JsonProperty(value="reconfigurable") boolean reconfigurable, @JsonProperty(value="label") String label, @JsonProperty(value="priority") Double priority) {
        this.name = name;
        this.type = type;
        this.description = description;
        this.defaultValue = defaultValue;
        this.reconfigurable = reconfigurable;
        this.label = label;
        this.priority = priority;
    }

    protected ConfigSummary(ConfigKey<?> config) {
        this.name = config.getName();
        this.type = config.getTypeName();
        this.description = config.getDescription();
        this.reconfigurable = config.isReconfigurable();
        this.defaultValue = config.getDefaultValue() == null ? null : config.getDefaultValue().toString();
        this.label = null;
        this.priority = null;
    }

    public String getName() {
        return this.name;
    }

    public String getType() {
        return this.type;
    }

    public String getDescription() {
        return this.description;
    }

    public boolean isReconfigurable() {
        return this.reconfigurable;
    }

    public Object getDefaultValue() {
        return this.defaultValue;
    }

    public String getLabel() {
        return this.label;
    }

    public Double getPriority() {
        return this.priority;
    }

    public abstract Map<String, URI> getLinks();

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ConfigSummary that = (ConfigSummary)o;
        return !(this.name != null ? !this.name.equals(that.name) : that.name != null);
    }

    public int hashCode() {
        int result = this.name != null ? this.name.hashCode() : 0;
        return result;
    }

    public abstract String toString();
}

