/*
 * Decompiled with CFR 0.152.
 */
package brooklyn.rest.domain;

import brooklyn.entity.Effector;
import brooklyn.entity.ParameterType;
import brooklyn.entity.basic.EntityLocal;
import brooklyn.rest.domain.ApplicationSummary;
import com.google.common.base.Function;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import java.net.URI;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;
import org.codehaus.jackson.annotate.JsonProperty;
import org.codehaus.jackson.map.annotate.JsonSerialize;

public class EffectorSummary {
    private final String name;
    private final String returnType;
    private final Set<ParameterSummary> parameters;
    @JsonSerialize(include=JsonSerialize.Inclusion.NON_NULL)
    private final String description;
    @JsonSerialize(include=JsonSerialize.Inclusion.NON_NULL)
    private final Map<String, URI> links;

    public EffectorSummary(@JsonProperty(value="name") String name, @JsonProperty(value="returnType") String returnType, @JsonProperty(value="parameters") Set<ParameterSummary> parameters, @JsonProperty(value="description") String description, @JsonProperty(value="links") Map<String, URI> links) {
        this.name = name;
        this.description = description;
        this.returnType = returnType;
        this.parameters = parameters;
        this.links = links != null ? ImmutableMap.copyOf(links) : null;
    }

    @Deprecated
    public EffectorSummary(ApplicationSummary application, EntityLocal entity, Effector<?> effector) {
        this.name = effector.getName();
        this.description = effector.getDescription();
        this.returnType = effector.getReturnTypeName();
        this.parameters = ImmutableSet.copyOf((Iterable)Iterables.transform((Iterable)effector.getParameters(), (Function)new Function<ParameterType<?>, ParameterSummary>(){

            public ParameterSummary apply(@Nullable ParameterType<?> parameterType) {
                return new ParameterSummary(parameterType);
            }
        }));
        String applicationUri = "/v1/applications/" + application.getSpec().getName();
        String entityUri = String.valueOf(applicationUri) + "/entities/" + entity.getId();
        this.links = ImmutableMap.of((Object)"self", (Object)URI.create(String.valueOf(entityUri) + "/effectors/" + effector.getName()), (Object)"entity", (Object)URI.create(entityUri), (Object)"application", (Object)URI.create(applicationUri));
    }

    public static EffectorSummary fromEntity(EntityLocal entity, Effector<?> effector) {
        return new EffectorSummary(entity, effector);
    }

    protected EffectorSummary(EntityLocal entity, Effector<?> effector) {
        this.name = effector.getName();
        this.description = effector.getDescription();
        this.returnType = effector.getReturnTypeName();
        this.parameters = ImmutableSet.copyOf((Iterable)Iterables.transform((Iterable)effector.getParameters(), (Function)new Function<ParameterType<?>, ParameterSummary>(){

            public ParameterSummary apply(@Nullable ParameterType<?> parameterType) {
                return new ParameterSummary(parameterType);
            }
        }));
        String applicationUri = "/v1/applications/" + entity.getApplicationId();
        String entityUri = String.valueOf(applicationUri) + "/entities/" + entity.getId();
        this.links = ImmutableMap.of((Object)"self", (Object)URI.create(String.valueOf(entityUri) + "/effectors/" + effector.getName()), (Object)"entity", (Object)URI.create(entityUri), (Object)"application", (Object)URI.create(applicationUri));
    }

    public static EffectorSummary forCatalog(Effector<?> effector) {
        ImmutableSet parameters = ImmutableSet.copyOf((Iterable)Iterables.transform((Iterable)effector.getParameters(), (Function)new Function<ParameterType<?>, ParameterSummary>(){

            public ParameterSummary apply(@Nullable ParameterType<?> parameterType) {
                return new ParameterSummary(parameterType);
            }
        }));
        return new EffectorSummary(effector.getName(), effector.getReturnTypeName(), (Set<ParameterSummary>)parameters, effector.getDescription(), null);
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public String getReturnType() {
        return this.returnType;
    }

    public Set<ParameterSummary> getParameters() {
        return this.parameters;
    }

    public Map<String, URI> getLinks() {
        return this.links;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        EffectorSummary that = (EffectorSummary)o;
        if (this.description != null ? !this.description.equals(that.description) : that.description != null) {
            return false;
        }
        if (this.links != null ? !this.links.equals(that.links) : that.links != null) {
            return false;
        }
        if (this.name != null ? !this.name.equals(that.name) : that.name != null) {
            return false;
        }
        if (this.parameters != null ? !this.parameters.equals(that.parameters) : that.parameters != null) {
            return false;
        }
        return !(this.returnType != null ? !this.returnType.equals(that.returnType) : that.returnType != null);
    }

    public int hashCode() {
        int result = this.name != null ? this.name.hashCode() : 0;
        result = 31 * result + (this.description != null ? this.description.hashCode() : 0);
        result = 31 * result + (this.returnType != null ? this.returnType.hashCode() : 0);
        result = 31 * result + (this.parameters != null ? this.parameters.hashCode() : 0);
        result = 31 * result + (this.links != null ? this.links.hashCode() : 0);
        return result;
    }

    public String toString() {
        return "EffectorSummary{name='" + this.name + '\'' + ", description='" + this.description + '\'' + ", returnType='" + this.returnType + '\'' + ", parameters=" + this.parameters + ", links=" + this.links + '}';
    }

    public static class ParameterSummary {
        private final String name;
        private final String type;
        @JsonSerialize(include=JsonSerialize.Inclusion.NON_NULL)
        private final String description;

        public ParameterSummary(@JsonProperty(value="name") String name, @JsonProperty(value="type") String type, @JsonProperty(value="description") String description) {
            this.name = name;
            this.type = type;
            this.description = description;
        }

        public ParameterSummary(ParameterType<?> type) {
            this.name = type.getName();
            this.type = type.getParameterClassName();
            this.description = type.getDescription();
        }

        public String getName() {
            return this.name;
        }

        public String getType() {
            return this.type;
        }

        public String getDescription() {
            return this.description;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ParameterSummary that = (ParameterSummary)o;
            if (this.description != null ? !this.description.equals(that.description) : that.description != null) {
                return false;
            }
            if (this.name != null ? !this.name.equals(that.name) : that.name != null) {
                return false;
            }
            return !(this.type != null ? !this.type.equals(that.type) : that.type != null);
        }

        public int hashCode() {
            int result = this.name != null ? this.name.hashCode() : 0;
            result = 31 * result + (this.type != null ? this.type.hashCode() : 0);
            result = 31 * result + (this.description != null ? this.description.hashCode() : 0);
            return result;
        }

        public String toString() {
            return "ParameterSummary{name='" + this.name + '\'' + ", type='" + this.type + '\'' + ", description='" + this.description + '\'' + '}';
        }
    }
}

