/*
 * Decompiled with CFR 0.152.
 */
package brooklyn.rest.domain;

import brooklyn.catalog.CatalogConfig;
import brooklyn.config.ConfigKey;
import brooklyn.entity.basic.EntityLocal;
import brooklyn.rest.domain.ConfigSummary;
import brooklyn.rest.util.JsonUtils;
import com.google.common.collect.ImmutableMap;
import java.lang.reflect.Field;
import java.net.URI;
import java.util.Map;
import org.codehaus.jackson.annotate.JsonProperty;
import org.codehaus.jackson.map.annotate.JsonSerialize;

public class EntityConfigSummary
extends ConfigSummary {
    @JsonSerialize(include=JsonSerialize.Inclusion.NON_NULL)
    private final Map<String, URI> links;

    public EntityConfigSummary(@JsonProperty(value="name") String name, @JsonProperty(value="type") String type, @JsonProperty(value="description") String description, @JsonProperty(value="defaultValue") Object defaultValue, @JsonProperty(value="reconfigurable") boolean reconfigurable, @JsonProperty(value="label") String label, @JsonProperty(value="priority") Double priority, @JsonProperty(value="links") Map<String, URI> links) {
        super(name, type, description, defaultValue, reconfigurable, label, priority);
        this.links = links != null ? ImmutableMap.copyOf(links) : null;
    }

    protected EntityConfigSummary(ConfigKey<?> config, String label, Double priority, Map<String, URI> links) {
        super(config.getName(), config.getTypeName(), config.getDescription(), JsonUtils.toJsonable(config.getDefaultValue()), config.isReconfigurable(), label, priority);
        this.links = links == null ? null : ImmutableMap.copyOf(links);
    }

    public static EntityConfigSummary fromEntity(EntityLocal entity, ConfigKey<?> config) {
        String label = null;
        Double priority = null;
        String applicationUri = "/v1/applications/" + entity.getApplicationId();
        String entityUri = String.valueOf(applicationUri) + "/entities/" + entity.getId();
        ImmutableMap links = ImmutableMap.builder().put((Object)"self", (Object)URI.create(String.valueOf(entityUri) + "/config/" + config.getName())).put((Object)"application", (Object)URI.create(applicationUri)).put((Object)"entity", (Object)URI.create(entityUri)).build();
        return new EntityConfigSummary(config, label, priority, (Map<String, URI>)links);
    }

    public static EntityConfigSummary forCatalog(ConfigKey<?> config) {
        return new EntityConfigSummary(config, null, null, null);
    }

    public static EntityConfigSummary forCatalog(ConfigKey<?> config, Field configKeyField) {
        CatalogConfig catalogConfig = configKeyField != null ? configKeyField.getAnnotation(CatalogConfig.class) : null;
        String label = catalogConfig == null ? null : catalogConfig.label();
        Double priority = catalogConfig == null ? null : Double.valueOf(catalogConfig.priority());
        return new EntityConfigSummary(config, label, priority, null);
    }

    @Override
    public Map<String, URI> getLinks() {
        return this.links;
    }

    @Override
    public String toString() {
        return "EntityConfigSummary{name='" + this.getName() + '\'' + ", type='" + this.getType() + '\'' + '}';
    }
}

