/*
 * Decompiled with CFR 0.152.
 */
package brooklyn.rest.domain;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.Collections;
import java.util.Map;
import org.codehaus.jackson.annotate.JsonProperty;

public class EntitySpec {
    private final String name;
    private final String type;
    private final Map<String, String> config;

    public EntitySpec(String type) {
        this(null, type);
    }

    public EntitySpec(String name, String type) {
        this(name, type, Collections.emptyMap());
    }

    public EntitySpec(@JsonProperty(value="name") String name, @JsonProperty(value="type") String type, @JsonProperty(value="config") Map<String, String> config) {
        this.type = (String)Preconditions.checkNotNull((Object)type, (Object)"type");
        this.name = name == null ? type : name;
        this.config = config != null ? ImmutableMap.copyOf(config) : ImmutableMap.of();
    }

    public String getName() {
        return this.name;
    }

    public String getType() {
        return this.type;
    }

    public Map<String, String> getConfig() {
        return this.config;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        EntitySpec entitySpec = (EntitySpec)o;
        if (this.config != null ? !this.config.equals(entitySpec.config) : entitySpec.config != null) {
            return false;
        }
        if (this.name != null ? !this.name.equals(entitySpec.name) : entitySpec.name != null) {
            return false;
        }
        return !(this.type != null ? !this.type.equals(entitySpec.type) : entitySpec.type != null);
    }

    public int hashCode() {
        int result = this.name != null ? this.name.hashCode() : 0;
        result = 31 * result + (this.type != null ? this.type.hashCode() : 0);
        result = 31 * result + (this.config != null ? this.config.hashCode() : 0);
        return result;
    }

    public String toString() {
        return "EntitySpec{name='" + this.name + '\'' + ", type='" + this.type + '\'' + ", config=" + this.config + '}';
    }
}

