/*
 * Decompiled with CFR 0.152.
 */
package brooklyn.rest.domain;

import brooklyn.entity.Entity;
import brooklyn.rest.domain.ApplicationSummary;
import com.google.common.collect.ImmutableMap;
import java.net.URI;
import java.util.Map;
import org.codehaus.jackson.annotate.JsonProperty;

public class EntitySummary {
    private final String id;
    private final String name;
    private final String type;
    private final Map<String, URI> links;

    public EntitySummary(@JsonProperty(value="id") String id, @JsonProperty(value="name") String name, @JsonProperty(value="type") String type, @JsonProperty(value="links") Map<String, URI> links) {
        this.type = type;
        this.id = id;
        this.name = name;
        this.links = ImmutableMap.copyOf(links);
    }

    @Deprecated
    public EntitySummary(ApplicationSummary application, Entity entity) {
        this(entity);
        assert (entity.getApplicationId().equals(application.getId()));
    }

    protected EntitySummary(Entity entity) {
        this.type = entity.getEntityType().getName();
        this.id = entity.getId();
        this.name = entity.getDisplayName();
        String applicationUri = "/v1/applications/" + entity.getApplicationId();
        String entityUri = String.valueOf(applicationUri) + "/entities/" + entity.getId();
        ImmutableMap.Builder lb = ImmutableMap.builder().put((Object)"self", (Object)URI.create(entityUri));
        if (entity.getParent() != null) {
            lb.put((Object)"parent", (Object)URI.create(String.valueOf(applicationUri) + "/entities/" + entity.getParent().getId()));
        }
        lb.put((Object)"application", (Object)URI.create(applicationUri)).put((Object)"children", (Object)URI.create(String.valueOf(entityUri) + "/entities")).put((Object)"config", (Object)URI.create(String.valueOf(entityUri) + "/config")).put((Object)"sensors", (Object)URI.create(String.valueOf(entityUri) + "/sensors")).put((Object)"effectors", (Object)URI.create(String.valueOf(entityUri) + "/effectors")).put((Object)"policies", (Object)URI.create(String.valueOf(entityUri) + "/policies")).put((Object)"activities", (Object)URI.create(String.valueOf(entityUri) + "/activities")).put((Object)"catalog", (Object)URI.create("/v1/catalog/entities/" + this.type));
        this.links = lb.build();
    }

    public static EntitySummary fromEntity(Entity entity) {
        return new EntitySummary(entity);
    }

    public String getType() {
        return this.type;
    }

    public String getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public Map<String, URI> getLinks() {
        return this.links;
    }

    public boolean equals(Object o) {
        return o instanceof EntitySummary && this.id.equals(((EntitySummary)o).getId());
    }

    public int hashCode() {
        return this.id != null ? this.id.hashCode() : 0;
    }

    public String toString() {
        return "EntitySummary{id='" + this.id + '\'' + ", links=" + this.links + '}';
    }
}

