/*
 * Decompiled with CFR 0.152.
 */
package brooklyn.rest.domain;

import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.Collections;
import java.util.Map;
import javax.annotation.Nullable;
import org.codehaus.jackson.annotate.JsonProperty;

public class LocationSpec {
    private final String name;
    private final String spec;
    private final Map<String, String> config;

    public static LocationSpec localhost() {
        return new LocationSpec("localhost", "localhost", null);
    }

    public LocationSpec(@JsonProperty(value="name") String name, @JsonProperty(value="spec") String spec, @JsonProperty(value="config") @Nullable Map<String, String> config) {
        this.name = name;
        this.spec = (String)Preconditions.checkNotNull((Object)spec, (Object)"spec");
        this.config = config == null ? Collections.emptyMap() : ImmutableMap.copyOf(config);
    }

    public String getName() {
        return this.name;
    }

    public String getSpec() {
        return this.spec;
    }

    public Map<String, String> getConfig() {
        return this.config;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        LocationSpec that = (LocationSpec)o;
        return Objects.equal((Object)this.name, (Object)that.name) && Objects.equal((Object)this.spec, (Object)that.spec) && Objects.equal(this.config, that.config);
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.spec, this.name, this.config});
    }

    public String toString() {
        return "LocationSpec{name='" + this.name + '\'' + "spec='" + this.spec + '\'' + ", config=" + this.config + '}';
    }
}

