/*
 * Decompiled with CFR 0.152.
 */
package brooklyn.rest.domain;

import brooklyn.entity.basic.Entities;
import brooklyn.location.Location;
import brooklyn.location.LocationDefinition;
import brooklyn.rest.domain.LocationSpec;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.net.URI;
import java.util.Map;
import java.util.Set;
import org.codehaus.jackson.annotate.JsonProperty;

public class LocationSummary
extends LocationSpec {
    private final String id;
    private final Map<String, URI> links;

    public LocationSummary(@JsonProperty(value="id") String id, @JsonProperty(value="name") String name, @JsonProperty(value="spec") String spec, @JsonProperty(value="config") Map<String, String> config, @JsonProperty(value="links") Map<String, URI> links) {
        super(name, spec, config);
        this.id = (String)Preconditions.checkNotNull((Object)id);
        this.links = ImmutableMap.copyOf(links);
    }

    public static LocationSummary newInstance(String id, LocationSpec locationSpec) {
        return new LocationSummary(id, locationSpec.getName(), locationSpec.getSpec(), LocationSummary.copyConfigsExceptSensitiveKeys(locationSpec.getConfig().entrySet()), (Map<String, URI>)ImmutableMap.of((Object)"self", (Object)URI.create("/v1/locations/" + id)));
    }

    public static LocationSummary newInstance(LocationDefinition l) {
        return new LocationSummary(l.getId(), l.getName(), l.getSpec(), LocationSummary.copyConfigsExceptSensitiveKeys(l.getConfig().entrySet()), (Map<String, URI>)ImmutableMap.of((Object)"self", (Object)URI.create("/v1/locations/" + l.getId())));
    }

    public static LocationSummary newInstance(LocationDefinition ld, Location ll) {
        return new LocationSummary(ld.getId(), ld.getName(), ld.getSpec(), LocationSummary.copyConfigsExceptSensitiveKeys(ll.getAllConfig().entrySet()), (Map<String, URI>)ImmutableMap.of((Object)"self", (Object)URI.create("/v1/locations/" + ld.getId())));
    }

    private static Map<String, String> copyConfigsExceptSensitiveKeys(Set entries) {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (Object entryO : entries) {
            Map.Entry entry = (Map.Entry)entryO;
            if (Entities.isSecret((String)((String)entry.getKey()))) continue;
            builder.put((Object)((String)entry.getKey()), entry.getValue() != null ? entry.getValue().toString() : null);
        }
        return builder.build();
    }

    public String getId() {
        return this.id;
    }

    public Map<String, URI> getLinks() {
        return this.links;
    }

    @Override
    public boolean equals(Object o) {
        if (!super.equals(o)) {
            return false;
        }
        LocationSummary that = (LocationSummary)o;
        return Objects.equal((Object)this.id, (Object)that.id);
    }

    @Override
    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.id, this.links});
    }

    @Override
    public String toString() {
        return "LocationSummary{id='" + this.getId() + '\'' + "name='" + this.getName() + '\'' + "spec='" + this.getSpec() + '\'' + ", config=" + this.getConfig() + ", links=" + this.links + '}';
    }
}

