/*
 * Decompiled with CFR 0.152.
 */
package brooklyn.rest.domain;

import brooklyn.config.ConfigKey;
import brooklyn.entity.basic.EntityLocal;
import brooklyn.policy.Policy;
import brooklyn.rest.domain.ApplicationSummary;
import brooklyn.rest.domain.ConfigSummary;
import com.google.common.collect.ImmutableMap;
import java.net.URI;
import java.util.Map;
import org.codehaus.jackson.annotate.JsonProperty;
import org.codehaus.jackson.map.annotate.JsonSerialize;

public class PolicyConfigSummary
extends ConfigSummary {
    @JsonSerialize(include=JsonSerialize.Inclusion.NON_NULL)
    private final Map<String, URI> links;

    public PolicyConfigSummary(@JsonProperty(value="name") String name, @JsonProperty(value="type") String type, @JsonProperty(value="description") String description, @JsonProperty(value="defaultValue") Object defaultValue, @JsonProperty(value="reconfigurable") boolean reconfigurable, @JsonProperty(value="links") Map<String, URI> links) {
        super(name, type, description, defaultValue, reconfigurable, null, null);
        this.links = links != null ? ImmutableMap.copyOf(links) : null;
    }

    public PolicyConfigSummary(ApplicationSummary application, EntityLocal entity, Policy policy, ConfigKey<?> config) {
        this(entity, policy, config);
        if (!entity.getApplicationId().equals(application.getInstance().getId())) {
            throw new IllegalStateException("Application " + application + " does not match app " + entity.getApplication() + " of " + entity);
        }
    }

    public PolicyConfigSummary(EntityLocal entity, Policy policy, ConfigKey<?> config) {
        super(config);
        String applicationUri = "/v1/applications/" + entity.getApplicationId();
        String entityUri = String.valueOf(applicationUri) + "/entities/" + entity.getId();
        String policyUri = String.valueOf(entityUri) + "/policies/" + policy.getId();
        this.links = ImmutableMap.builder().put((Object)"self", (Object)URI.create(String.valueOf(policyUri) + "/config/" + config.getName())).put((Object)"application", (Object)URI.create(applicationUri)).put((Object)"entity", (Object)URI.create(entityUri)).put((Object)"policy", (Object)URI.create(policyUri)).build();
    }

    @Override
    public Map<String, URI> getLinks() {
        return this.links;
    }

    @Override
    public String toString() {
        return "PolicyConfigSummary{name='" + this.getName() + '\'' + ", type='" + this.getType() + '\'' + '}';
    }
}

