/*
 * Decompiled with CFR 0.152.
 */
package brooklyn.rest.domain;

import brooklyn.entity.Entity;
import brooklyn.entity.basic.EntityLocal;
import brooklyn.entity.basic.Lifecycle;
import brooklyn.policy.Policy;
import brooklyn.policy.basic.Policies;
import brooklyn.rest.domain.ApplicationSummary;
import com.google.common.collect.ImmutableMap;
import java.net.URI;
import java.util.Map;
import org.codehaus.jackson.annotate.JsonProperty;

public class PolicySummary {
    private final String id;
    private final String name;
    private final Lifecycle state;
    private final Map<String, URI> links;

    public PolicySummary(@JsonProperty(value="id") String id, @JsonProperty(value="name") String name, @JsonProperty(value="state") Lifecycle state, @JsonProperty(value="links") Map<String, URI> links) {
        this.id = id;
        this.name = name;
        this.state = state;
        this.links = ImmutableMap.copyOf(links);
    }

    @Deprecated
    public PolicySummary(ApplicationSummary application, EntityLocal entity, Policy policy) {
        this((Entity)entity, policy);
        assert (application.getId().equals(entity.getApplicationId()));
    }

    protected PolicySummary(Entity entity, Policy policy) {
        this.id = policy.getId();
        this.name = policy.getName();
        this.state = Policies.getPolicyStatus((Policy)policy);
        String applicationUri = "/v1/applications/" + entity.getApplicationId();
        String entityUri = String.valueOf(applicationUri) + "/entities/" + entity.getId();
        this.links = ImmutableMap.builder().put((Object)"self", (Object)URI.create(String.valueOf(entityUri) + "/policies/" + policy.getId())).put((Object)"config", (Object)URI.create(String.valueOf(entityUri) + "/policies/" + policy.getId() + "/config")).put((Object)"start", (Object)URI.create(String.valueOf(entityUri) + "/policies/" + policy.getId() + "/start")).put((Object)"stop", (Object)URI.create(String.valueOf(entityUri) + "/policies/" + policy.getId() + "/stop")).put((Object)"destroy", (Object)URI.create(String.valueOf(entityUri) + "/policies/" + policy.getId() + "/destroy")).put((Object)"application", (Object)URI.create(applicationUri)).put((Object)"entity", (Object)URI.create(entityUri)).build();
    }

    public static PolicySummary fromEntity(Entity entity, Policy policy) {
        return new PolicySummary(entity, policy);
    }

    public String getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public Lifecycle getState() {
        return this.state;
    }

    public Map<String, URI> getLinks() {
        return this.links;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PolicySummary that = (PolicySummary)o;
        if (this.id != null ? !this.id.equals(that.id) : that.id != null) {
            return false;
        }
        return !(this.name != null ? !this.name.equals(that.name) : that.name != null);
    }

    public int hashCode() {
        int result = this.name != null ? this.name.hashCode() : 0;
        result = 31 * result + (this.id != null ? this.id.hashCode() : 0);
        return result;
    }

    public String toString() {
        return "ConfigSummary{name='" + this.name + '\'' + ", id='" + this.id + '\'' + ", links=" + this.links + '}';
    }
}

