/*
 * Decompiled with CFR 0.152.
 */
package brooklyn.rest.domain;

import brooklyn.config.render.RendererHints;
import brooklyn.entity.Entity;
import brooklyn.entity.basic.EntityLocal;
import brooklyn.event.AttributeSensor;
import brooklyn.event.Sensor;
import brooklyn.rest.domain.ApplicationSummary;
import brooklyn.rest.util.URLParamEncoder;
import brooklyn.util.MutableMap;
import brooklyn.util.exceptions.Exceptions;
import com.google.common.collect.ImmutableMap;
import java.net.URI;
import java.util.Map;
import java.util.Set;
import org.codehaus.jackson.annotate.JsonProperty;
import org.codehaus.jackson.map.annotate.JsonSerialize;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SensorSummary {
    private static final Logger log = LoggerFactory.getLogger(SensorSummary.class);
    private final String name;
    private final String type;
    @JsonSerialize(include=JsonSerialize.Inclusion.NON_NULL)
    private final String description;
    @JsonSerialize(include=JsonSerialize.Inclusion.NON_NULL)
    private final Map<String, URI> links;

    public SensorSummary(@JsonProperty(value="name") String name, @JsonProperty(value="type") String type, @JsonProperty(value="description") String description, @JsonProperty(value="links") Map<String, URI> links) {
        this.name = name;
        this.type = type;
        this.description = description;
        this.links = links != null ? ImmutableMap.copyOf(links) : null;
    }

    @Deprecated
    public SensorSummary(ApplicationSummary application, EntityLocal entity, Sensor<?> sensor) {
        this((Entity)entity, sensor);
    }

    protected SensorSummary(Entity entity, Sensor<?> sensor) {
        this.name = sensor.getName();
        this.type = sensor.getTypeName();
        this.description = sensor.getDescription();
        String applicationUri = "/v1/applications/" + entity.getApplicationId();
        String entityUri = String.valueOf(applicationUri) + "/entities/" + entity.getId();
        String selfUri = String.valueOf(entityUri) + "/sensors/" + URLParamEncoder.encode(sensor.getName());
        MutableMap.Builder lb = MutableMap.builder().put((Object)"self", (Object)URI.create(selfUri)).put((Object)"application", (Object)URI.create(applicationUri)).put((Object)"entity", (Object)URI.create(entityUri)).put((Object)"action:json", (Object)URI.create(selfUri));
        Set hints = RendererHints.getHintsFor(sensor);
        for (RendererHints.Hint h : hints) {
            this.addRendererHint((MutableMap.Builder<String, URI>)lb, h, entity, sensor);
        }
        this.links = lb.build();
    }

    private void addRendererHint(MutableMap.Builder<String, URI> lb, RendererHints.Hint h, Entity entity, Sensor<?> sensor) {
        if (!(h instanceof RendererHints.NamedAction)) {
            return;
        }
        if (h instanceof RendererHints.NamedActionWithUrl) {
            try {
                String v = ((RendererHints.NamedActionWithUrl)h).getUrl(entity, (AttributeSensor)sensor);
                if (v != null && !v.isEmpty()) {
                    lb.putIfAbsent((Object)"action:open", (Object)URI.create(v));
                }
            }
            catch (Exception e) {
                Exceptions.propagateIfFatal((Throwable)e);
                log.warn("Unable to make use of URL sensor " + sensor + " on " + entity + ": " + e);
            }
        }
    }

    public static SensorSummary fromEntity(EntityLocal entity, Sensor<?> sensor) {
        return new SensorSummary((Entity)entity, sensor);
    }

    public static SensorSummary forCatalog(Sensor<?> sensor) {
        return new SensorSummary(sensor.getName(), sensor.getTypeName(), sensor.getDescription(), null);
    }

    public String getName() {
        return this.name;
    }

    public String getType() {
        return this.type;
    }

    public String getDescription() {
        return this.description;
    }

    public Map<String, URI> getLinks() {
        return this.links;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SensorSummary that = (SensorSummary)o;
        if (this.description != null ? !this.description.equals(that.description) : that.description != null) {
            return false;
        }
        if (this.links != null ? !this.links.equals(that.links) : that.links != null) {
            return false;
        }
        if (this.name != null ? !this.name.equals(that.name) : that.name != null) {
            return false;
        }
        return !(this.type != null ? !this.type.equals(that.type) : that.type != null);
    }

    public int hashCode() {
        int result = this.name != null ? this.name.hashCode() : 0;
        result = 31 * result + (this.type != null ? this.type.hashCode() : 0);
        result = 31 * result + (this.description != null ? this.description.hashCode() : 0);
        result = 31 * result + (this.links != null ? this.links.hashCode() : 0);
        return result;
    }

    public String toString() {
        return "SensorSummary{name='" + this.name + '\'' + ", type='" + this.type + '\'' + ", description='" + this.description + '\'' + ", links=" + this.links + '}';
    }
}

