/*
 * Decompiled with CFR 0.152.
 */
package brooklyn.rest.domain;

import brooklyn.entity.Entity;
import brooklyn.management.Task;
import brooklyn.rest.util.JsonUtils;
import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.TimeZone;
import javax.annotation.Nullable;
import org.codehaus.jackson.annotate.JsonIgnore;
import org.codehaus.jackson.annotate.JsonProperty;

public class TaskSummary {
    private final String entityId;
    private final String entityDisplayName;
    private final String displayName;
    private final String description;
    private final String id;
    private final Collection<Object> tags;
    private final long rawSubmitTimeUtc;
    private final String submitTimeUtc;
    private final String startTimeUtc;
    private final String endTimeUtc;
    private final String currentStatus;
    private final String detailedStatus;
    public static final Function<Task<?>, TaskSummary> FROM_TASK = new Function<Task<?>, TaskSummary>(){

        public TaskSummary apply(@Nullable Task<?> input) {
            return TaskSummary.fromTask(input);
        }
    };
    private static final ThreadLocal<DateFormat> formatter = new ThreadLocal<DateFormat>(){

        @Override
        protected DateFormat initialValue() {
            SimpleDateFormat result = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            result.setTimeZone(TimeZone.getTimeZone("GMT"));
            return result;
        }
    };

    public TaskSummary(@JsonProperty(value="entityId") String entityId, @JsonProperty(value="entityDisplayName") String entityDisplayName, @JsonProperty(value="displayName") String displayName, @JsonProperty(value="description") String description, @JsonProperty(value="id") String id, @JsonProperty(value="tags") Collection<Object> tags, @JsonProperty(value="rawSubmitTimeUtc") long rawSubmitTimeUtc, @JsonProperty(value="submitTimeUtc") String submitTimeUtc, @JsonProperty(value="startTimeUtc") String startTimeUtc, @JsonProperty(value="endTimeUtc") String endTimeUtc, @JsonProperty(value="currentStatus") String currentStatus, @JsonProperty(value="detailedStatus") String detailedStatus) {
        this.entityId = entityId;
        this.entityDisplayName = entityDisplayName;
        this.displayName = displayName;
        this.description = description;
        this.id = id;
        this.tags = ImmutableList.copyOf(tags);
        this.rawSubmitTimeUtc = rawSubmitTimeUtc;
        this.submitTimeUtc = submitTimeUtc;
        this.startTimeUtc = startTimeUtc;
        this.endTimeUtc = endTimeUtc;
        this.currentStatus = currentStatus;
        this.detailedStatus = detailedStatus;
    }

    public TaskSummary(Task task) {
        Preconditions.checkNotNull((Object)task);
        Entity entity = (Entity)Iterables.tryFind((Iterable)task.getTags(), (Predicate)Predicates.instanceOf(Entity.class)).orNull();
        if (entity != null) {
            this.entityId = entity.getId();
            this.entityDisplayName = entity.getDisplayName();
        } else {
            this.entityId = null;
            this.entityDisplayName = null;
        }
        this.tags = task.getTags();
        this.displayName = task.getDisplayName();
        this.description = task.getDescription();
        this.id = task.getId();
        this.rawSubmitTimeUtc = task.getSubmitTimeUtc();
        this.submitTimeUtc = task.getSubmitTimeUtc() == -1L ? "" : formatter.get().format(new Date(task.getSubmitTimeUtc()));
        this.startTimeUtc = task.getStartTimeUtc() == -1L ? "" : formatter.get().format(new Date(task.getStartTimeUtc()));
        this.endTimeUtc = task.getEndTimeUtc() == -1L ? "" : formatter.get().format(new Date(task.getEndTimeUtc()));
        this.currentStatus = task.getStatusSummary();
        this.detailedStatus = task.getStatusDetail(true);
    }

    public static final TaskSummary fromTask(Task<?> task) {
        return new TaskSummary(task);
    }

    public String getEntityId() {
        return this.entityId;
    }

    public String getEntityDisplayName() {
        return this.entityDisplayName;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public String getDescription() {
        return this.description;
    }

    public String getId() {
        return this.id;
    }

    public Collection<Object> getTags() {
        ArrayList<Object> result = new ArrayList<Object>();
        for (Object t : this.tags) {
            result.add(JsonUtils.toJsonable(t));
        }
        return result;
    }

    @JsonIgnore
    public Collection<Object> getRawTags() {
        return this.tags;
    }

    public long getRawSubmitTimeUtc() {
        return this.rawSubmitTimeUtc;
    }

    public String getSubmitTimeUtc() {
        return this.submitTimeUtc;
    }

    public String getStartTimeUtc() {
        return this.startTimeUtc;
    }

    public String getEndTimeUtc() {
        return this.endTimeUtc;
    }

    public String getCurrentStatus() {
        return this.currentStatus;
    }

    public String getDetailedStatus() {
        return this.detailedStatus;
    }

    public String toString() {
        return "TaskSummary{id='" + this.id + '\'' + ", displayName='" + this.displayName + '\'' + ", currentStatus='" + this.currentStatus + '\'' + ", startTimeUtc='" + this.startTimeUtc + '\'' + ", endTimeUtc='" + this.endTimeUtc + '\'' + '}';
    }
}

