/*
 * Decompiled with CFR 0.152.
 */
package brooklyn.rest.resources;

import brooklyn.entity.basic.EntityLocal;
import brooklyn.management.Task;
import brooklyn.rest.apidoc.Apidoc;
import brooklyn.rest.domain.TaskSummary;
import brooklyn.rest.resources.AbstractBrooklynRestResource;
import brooklyn.rest.util.WebResourceUtils;
import com.google.common.collect.Collections2;
import com.wordnik.swagger.core.ApiError;
import com.wordnik.swagger.core.ApiErrors;
import com.wordnik.swagger.core.ApiOperation;
import com.wordnik.swagger.core.ApiParam;
import java.util.Collection;
import java.util.Set;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;

@Path(value="/v1/applications/{application}/entities/{entity}/activities")
@Apidoc(value="Activities")
@Produces(value={"application/json"})
public class ActivityResource
extends AbstractBrooklynRestResource {
    @GET
    @ApiOperation(value="Fetch list of activities for this application")
    public Iterable<TaskSummary> list(@PathParam(value="application") String applicationId, @PathParam(value="entity") String entityId) {
        EntityLocal entity = this.brooklyn().getEntity(applicationId, entityId);
        Set tasks = this.mgmt().getExecutionManager().getTasksWithTag((Object)entity);
        return Collections2.transform((Collection)tasks, TaskSummary.FROM_TASK);
    }

    @GET
    @Path(value="/{task}")
    @ApiOperation(value="Fetch task details", responseClass="brooklyn.rest.domain.TaskSummary")
    @ApiErrors(value={@ApiError(code=404, reason="Could not find application, entity or task")})
    @Produces(value={"text/json"})
    public TaskSummary get(@ApiParam(value="Application ID or name", required=true) @PathParam(value="application") String application, @ApiParam(value="Entity ID or name", required=true) @PathParam(value="entity") String entityToken, @ApiParam(value="Task ID", required=true) @PathParam(value="task") String taskId) {
        Task t = this.mgmt().getExecutionManager().getTask(taskId);
        if (t == null) {
            throw WebResourceUtils.notFound("Cannot find task '%s'", taskId);
        }
        return (TaskSummary)TaskSummary.FROM_TASK.apply((Object)t);
    }
}

