/*
 * Decompiled with CFR 0.152.
 */
package brooklyn.rest.resources;

import brooklyn.entity.Application;
import brooklyn.entity.Entity;
import brooklyn.management.Task;
import brooklyn.rest.apidoc.Apidoc;
import brooklyn.rest.domain.ApplicationSpec;
import brooklyn.rest.domain.ApplicationSummary;
import brooklyn.rest.domain.EntitySpec;
import brooklyn.rest.domain.TaskSummary;
import brooklyn.rest.resources.AbstractBrooklynRestResource;
import brooklyn.rest.util.BrooklynRestResourceUtils;
import brooklyn.rest.util.WebResourceUtils;
import com.google.common.base.Preconditions;
import com.google.common.collect.Collections2;
import com.wordnik.swagger.core.ApiError;
import com.wordnik.swagger.core.ApiErrors;
import com.wordnik.swagger.core.ApiOperation;
import com.wordnik.swagger.core.ApiParam;
import java.net.URI;
import java.util.Collection;
import javax.validation.Valid;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import org.codehaus.jackson.JsonNode;
import org.codehaus.jackson.map.ObjectMapper;
import org.codehaus.jackson.node.ArrayNode;
import org.codehaus.jackson.node.ObjectNode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="/v1/applications")
@Apidoc(value="Applications")
@Produces(value={"application/json"})
public class ApplicationResource
extends AbstractBrooklynRestResource {
    private static final Logger log = LoggerFactory.getLogger(ApplicationResource.class);
    private final ObjectMapper mapper = new ObjectMapper();

    @GET
    @Path(value="/tree")
    @ApiOperation(value="Fetch applications and entities tree hierarchy")
    public JsonNode applicationTree() {
        ArrayNode apps = this.mapper.createArrayNode();
        for (Application application : this.mgmt().getApplications()) {
            apps.add(this.recursiveTreeFromEntity((Entity)application));
        }
        return apps;
    }

    private JsonNode recursiveTreeFromEntity(Entity entity) {
        ObjectNode aRoot = this.mapper.createObjectNode();
        aRoot.put("name", entity.getDisplayName());
        aRoot.put("id", entity.getId());
        aRoot.put("type", entity.getEntityType().getName());
        if (entity.getChildren().size() != 0) {
            aRoot.put("children", (JsonNode)this.childEntitiesAsArray(entity));
        }
        return aRoot;
    }

    private ArrayNode childEntitiesAsArray(Entity entity) {
        ArrayNode node = this.mapper.createArrayNode();
        for (Entity e : entity.getChildren()) {
            node.add(this.recursiveTreeFromEntity(e));
        }
        return node;
    }

    @GET
    @ApiOperation(value="Fetch list of applications", responseClass="brooklyn.rest.domain.ApplicationSummary")
    public Iterable<ApplicationSummary> list() {
        return Collections2.transform((Collection)this.mgmt().getApplications(), ApplicationSummary.FROM_APPLICATION);
    }

    @GET
    @Path(value="/{application}")
    @ApiOperation(value="Fetch a specific application", responseClass="brooklyn.rest.domain.ApplicationSummary")
    @ApiErrors(value={@ApiError(code=404, reason="Application not found")})
    public ApplicationSummary get(@ApiParam(value="ID or name of application whose details will be returned", required=true) @PathParam(value="application") String application) {
        return ApplicationSummary.fromApplication(this.brooklyn().getApplication(application));
    }

    @POST
    @ApiOperation(value="Create and start a new application", responseClass="brooklyn.rest.domain.TaskSummary")
    @ApiErrors(value={@ApiError(code=404, reason="Undefined entity or location"), @ApiError(code=412, reason="Application already registered")})
    public Response create(@ApiParam(name="applicationSpec", value="Specification for application to be created, with name, locations, and entities or type fields", required=true) @Valid ApplicationSpec applicationSpec) {
        this.checkApplicationTypesAreValid(applicationSpec);
        this.checkLocationsAreValid(applicationSpec);
        Application app = this.brooklyn().create(applicationSpec);
        Task<?> t = this.brooklyn().start(app, applicationSpec);
        TaskSummary ts = (TaskSummary)TaskSummary.FROM_TASK.apply(t);
        URI ref = URI.create(app.getApplicationId());
        return Response.created((URI)ref).entity((Object)ts).build();
    }

    @DELETE
    @Path(value="/{application}")
    @ApiOperation(value="Delete a specified application", responseClass="brooklyn.rest.domain.TaskSummary")
    @ApiErrors(value={@ApiError(code=404, reason="Application not found")})
    public Response delete(@ApiParam(name="application", value="Application name", required=true) @PathParam(value="application") String application) {
        Task<?> t = this.brooklyn().destroy(this.brooklyn().getApplication(application));
        TaskSummary ts = (TaskSummary)TaskSummary.FROM_TASK.apply(t);
        return Response.status((Response.Status)Response.Status.ACCEPTED).entity((Object)ts).build();
    }

    private void checkApplicationTypesAreValid(ApplicationSpec applicationSpec) {
        String appType = applicationSpec.getType();
        if (appType != null) {
            this.checkEntityTypeIsValid(appType);
            if (applicationSpec.getEntities() != null) {
                throw WebResourceUtils.preconditionFailed("Application given explicit type '%s' must not define entities", appType);
            }
            return;
        }
        for (EntitySpec entitySpec : applicationSpec.getEntities()) {
            String entityType = entitySpec.getType();
            this.checkEntityTypeIsValid((String)Preconditions.checkNotNull((Object)entityType, (Object)"entityType"));
        }
    }

    private void checkEntityTypeIsValid(String type) {
        if (this.brooklyn().getCatalog().getCatalogItem(type) == null) {
            try {
                this.brooklyn().getCatalog().getRootClassLoader().loadClass(type);
            }
            catch (ClassNotFoundException e) {
                log.debug("Class not found for type '" + type + "'; reporting 404", (Throwable)e);
                throw WebResourceUtils.notFound("Undefined type '%s'", type);
            }
            log.info("Entity type '{}' not defined in catalog but is on classpath; continuing", (Object)type);
        }
    }

    private void checkLocationsAreValid(ApplicationSpec applicationSpec) {
        for (String locationId : applicationSpec.getLocations()) {
            locationId = BrooklynRestResourceUtils.fixLocation(locationId);
            if (this.brooklyn().getLocationRegistry().canResolve(locationId)) continue;
            throw WebResourceUtils.notFound("Undefined location '%s'", locationId);
        }
    }
}

