/*
 * Decompiled with CFR 0.152.
 */
package brooklyn.rest.resources;

import brooklyn.catalog.CatalogItem;
import brooklyn.catalog.CatalogPredicates;
import brooklyn.entity.Entity;
import brooklyn.rest.apidoc.Apidoc;
import brooklyn.rest.domain.CatalogEntitySummary;
import brooklyn.rest.domain.CatalogItemSummary;
import brooklyn.rest.resources.AbstractBrooklynRestResource;
import brooklyn.rest.util.WebResourceUtils;
import brooklyn.util.text.StringPredicates;
import brooklyn.util.text.Strings;
import com.google.common.base.Charsets;
import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.io.CharStreams;
import com.sun.jersey.core.header.FormDataContentDisposition;
import com.sun.jersey.multipart.FormDataParam;
import com.wordnik.swagger.core.ApiError;
import com.wordnik.swagger.core.ApiErrors;
import com.wordnik.swagger.core.ApiOperation;
import com.wordnik.swagger.core.ApiParam;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import javax.validation.Valid;
import javax.ws.rs.Consumes;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;

@Path(value="/v1/catalog")
@Apidoc(value="Catalog")
@Produces(value={"application/json"})
public class CatalogResource
extends AbstractBrooklynRestResource {
    private static final Function<CatalogItem, CatalogItemSummary> TO_CATALOG_ITEM_SUMMARY = new Function<CatalogItem, CatalogItemSummary>(){

        public CatalogItemSummary apply(@Nullable CatalogItem input) {
            return CatalogItemSummary.from(input);
        }
    };

    @POST
    @ApiOperation(value="Add a new entity or policy type to the catalog by uploading a Groovy script from browser using multipart/form-data", responseClass="String")
    @Consumes(value={"multipart/form-data"})
    public Response createFromMultipart(@ApiParam(name="groovyCode", value="multipart/form-data file input field") @FormDataParam(value="groovyCode") InputStream uploadedInputStream, @FormDataParam(value="groovyCode") FormDataContentDisposition fileDetail) throws IOException {
        return this.brooklyn().createCatalogEntryFromGroovyCode(CharStreams.toString((Readable)new InputStreamReader(uploadedInputStream, Charsets.UTF_8)));
    }

    @POST
    @ApiOperation(value="Add a new entity or policy type by uploading a Groovy script", responseClass="String")
    public Response create(@ApiParam(name="groovyCode", value="Groovy code for the entity or policy", required=true) @Valid String groovyCode) {
        return this.brooklyn().createCatalogEntryFromGroovyCode(groovyCode);
    }

    @GET
    @Path(value="/entities")
    @ApiOperation(value="List available entity types optionally matching a query", responseClass="CatalogItemSummary", multiValueResponse=true)
    public List<CatalogItemSummary> listEntities(@ApiParam(name="regex", value="Regular expression to search for") @QueryParam(value="regex") @DefaultValue(value="") String regex, @ApiParam(name="fragment", value="Substring case-insensitive to search for") @QueryParam(value="fragment") @DefaultValue(value="") String fragment) {
        return this.getCatalogItemSummariesMatchingRegexFragment(CatalogPredicates.IS_ENTITY, regex, fragment);
    }

    @GET
    @Path(value="/applications")
    @ApiOperation(value="Fetch a list of application templates optionally matching a query", responseClass="CatalogItemSummary", multiValueResponse=true)
    public List<CatalogItemSummary> listApplications(@ApiParam(name="regex", value="Regular expression to search for") @QueryParam(value="regex") @DefaultValue(value="") String regex, @ApiParam(name="fragment", value="Substring case-insensitive to search for") @QueryParam(value="fragment") @DefaultValue(value="") String fragment) {
        return this.getCatalogItemSummariesMatchingRegexFragment(CatalogPredicates.IS_TEMPLATE, regex, fragment);
    }

    @GET
    @Path(value="/entities/{entityId}")
    @ApiOperation(value="Fetch an entity's definition from the catalog", responseClass="CatalogEntitySummary", multiValueResponse=true)
    @ApiErrors(value={@ApiError(code=404, reason="Entity not found")})
    public CatalogEntitySummary getEntity(@ApiParam(name="entityId", value="The ID of the entity or template to retrieve", required=true) @PathParam(value="entityId") String entityId) throws Exception {
        CatalogItem result = this.brooklyn().getCatalog().getCatalogItem(entityId);
        if (result == null) {
            throw WebResourceUtils.notFound("Entity with id '%s' not found", entityId);
        }
        return CatalogEntitySummary.from(this.brooklyn(), (CatalogItem<? extends Entity>)result);
    }

    @GET
    @Path(value="/policies")
    @ApiOperation(value="List available policies optionally matching a query", responseClass="CatalogItemSummary", multiValueResponse=true)
    public List<CatalogItemSummary> listPolicies(@ApiParam(name="regex", value="Regular expression to search for") @QueryParam(value="regex") @DefaultValue(value="") String regex, @ApiParam(name="fragment", value="Substring case-insensitive to search for") @QueryParam(value="fragment") @DefaultValue(value="") String fragment) {
        return this.getCatalogItemSummariesMatchingRegexFragment(CatalogPredicates.IS_POLICY, regex, fragment);
    }

    @GET
    @Path(value="/policies/{policyId}")
    @ApiOperation(value="Fetch a policy's definition from the catalog", responseClass="CatalogItemSummary", multiValueResponse=true)
    @ApiErrors(value={@ApiError(code=404, reason="Entity not found")})
    public CatalogItemSummary getPolicy(@ApiParam(name="policyId", value="The ID of the policy to retrieve", required=true) @PathParam(value="policyId") String policyId) throws Exception {
        CatalogItem result = this.brooklyn().getCatalog().getCatalogItem(policyId);
        if (result == null) {
            throw WebResourceUtils.notFound("Policy with id '%s' not found", policyId);
        }
        return CatalogItemSummary.from(result);
    }

    private <T> List<CatalogItemSummary> getCatalogItemSummariesMatchingRegexFragment(Predicate<CatalogItem<T>> type, String regex, String fragment) {
        ArrayList<Object> filters = new ArrayList<Object>();
        filters.add(type);
        if (Strings.isNonEmpty((CharSequence)regex)) {
            filters.add(CatalogPredicates.xml((Predicate)StringPredicates.containsRegex((String)regex)));
        }
        if (Strings.isNonEmpty((CharSequence)fragment)) {
            filters.add(CatalogPredicates.xml((Predicate)StringPredicates.containsLiteralCaseInsensitive((String)fragment)));
        }
        return ImmutableList.copyOf((Iterable)Iterables.transform((Iterable)this.brooklyn().getCatalog().getCatalogItems(Predicates.and(filters)), TO_CATALOG_ITEM_SUMMARY));
    }
}

