/*
 * Decompiled with CFR 0.152.
 */
package brooklyn.rest.resources;

import brooklyn.config.ConfigKey;
import brooklyn.entity.basic.AbstractEntity;
import brooklyn.entity.basic.EntityInternal;
import brooklyn.entity.basic.EntityLocal;
import brooklyn.event.basic.BasicConfigKey;
import brooklyn.rest.apidoc.Apidoc;
import brooklyn.rest.domain.EntityConfigSummary;
import brooklyn.rest.resources.AbstractBrooklynRestResource;
import com.google.common.base.Function;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.wordnik.swagger.core.ApiError;
import com.wordnik.swagger.core.ApiErrors;
import com.wordnik.swagger.core.ApiOperation;
import com.wordnik.swagger.core.ApiParam;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Future;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;

@Path(value="/v1/applications/{application}/entities/{entity}/config")
@Apidoc(value="Entity config")
@Produces(value={"application/json"})
public class EntityConfigResource
extends AbstractBrooklynRestResource {
    @GET
    @ApiOperation(value="Fetch the config keys for a specific application entity", responseClass="brooklyn.rest.domain.ConfigSummary", multiValueResponse=true)
    @ApiErrors(value={@ApiError(code=404, reason="Could not find application or entity")})
    public List<EntityConfigSummary> list(@ApiParam(value="Application ID or name", required=true) @PathParam(value="application") String application, @ApiParam(value="Entity ID or name", required=true) @PathParam(value="entity") String entityToken) {
        final EntityLocal entity = this.brooklyn().getEntity(application, entityToken);
        return Lists.newArrayList((Iterable)Iterables.transform((Iterable)entity.getEntityType().getConfigKeys(), (Function)new Function<ConfigKey<?>, EntityConfigSummary>(){

            public EntityConfigSummary apply(ConfigKey<?> config) {
                return EntityConfigSummary.fromEntity(entity, config);
            }
        }));
    }

    @GET
    @Path(value="/current-state")
    @ApiOperation(value="Fetch config key values in batch", notes="Returns a map of config name to value")
    public Map<String, Object> batchConfigRead(@ApiParam(value="Application ID or name", required=true) @PathParam(value="application") String application, @ApiParam(value="Entity ID or name", required=true) @PathParam(value="entity") String entityToken) {
        EntityLocal entity = this.brooklyn().getEntity(application, entityToken);
        Map source = ((EntityInternal)entity).getAllConfig();
        LinkedHashMap result = Maps.newLinkedHashMap();
        for (Map.Entry ek : source.entrySet()) {
            result.put(((ConfigKey)ek.getKey()).getName(), this.getValueForDisplay(entity, ek.getValue()));
        }
        return result;
    }

    @GET
    @Path(value="/{config}")
    @ApiOperation(value="Fetch config value", responseClass="Object")
    @ApiErrors(value={@ApiError(code=404, reason="Could not find application, entity or config key")})
    public String get(@ApiParam(value="Application ID or name", required=true) @PathParam(value="application") String application, @ApiParam(value="Entity ID or name", required=true) @PathParam(value="entity") String entityToken, @ApiParam(value="Config key ID", required=true) @PathParam(value="config") String configKeyName) {
        EntityLocal entity = this.brooklyn().getEntity(application, entityToken);
        ConfigKey ck = entity.getEntityType().getConfigKey(configKeyName);
        if (ck == null) {
            ck = new BasicConfigKey(Object.class, configKeyName);
        }
        return this.getValueForDisplay(entity, ((AbstractEntity)entity).getConfigMap().getRawConfig(ck));
    }

    private String getValueForDisplay(EntityLocal entity, Object value) {
        if (value instanceof Future && ((Future)value).isDone()) {
            try {
                value = ((Future)value).get();
            }
            catch (Exception e) {
                value = value + " (error evaluating: " + e + ")";
            }
        }
        return value != null ? value.toString() : null;
    }
}

