/*
 * Decompiled with CFR 0.152.
 */
package brooklyn.rest.resources;

import brooklyn.entity.Entity;
import brooklyn.rest.apidoc.Apidoc;
import brooklyn.rest.domain.EntitySummary;
import brooklyn.rest.resources.AbstractBrooklynRestResource;
import com.google.common.base.Function;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.wordnik.swagger.core.ApiError;
import com.wordnik.swagger.core.ApiErrors;
import com.wordnik.swagger.core.ApiOperation;
import com.wordnik.swagger.core.ApiParam;
import java.util.List;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;

@Path(value="/v1/applications/{application}/entities")
@Apidoc(value="Application entities")
@Produces(value={"application/json"})
public class EntityResource
extends AbstractBrooklynRestResource {
    @GET
    @ApiOperation(value="Fetch the list of entities for a given application", responseClass="brooklyn.rest.domain.EntitySummary", multiValueResponse=true)
    @ApiErrors(value={@ApiError(code=404, reason="Application not found")})
    public List<EntitySummary> list(@ApiParam(value="Application ID or name", required=true) @PathParam(value="application") String application) {
        return this.summaryForChildrenEntities((Entity)this.brooklyn().getApplication(application));
    }

    @GET
    @Path(value="/{entity}")
    @ApiOperation(value="Fetch details about a specific application entity", responseClass="brooklyn.rest.domain.EntitySummary")
    @ApiErrors(value={@ApiError(code=404, reason="Application or entity missing")})
    public EntitySummary get(@ApiParam(value="Application ID or name", required=true) @PathParam(value="application") String application, @ApiParam(value="Entity ID or name", required=true) @PathParam(value="entity") String entity) {
        return EntitySummary.fromEntity((Entity)this.brooklyn().getEntity(application, entity));
    }

    @GET
    @Path(value="/{entity}/entities")
    public Iterable<EntitySummary> getChildren(@PathParam(value="application") String application, @PathParam(value="entity") String entity) {
        return this.summaryForChildrenEntities((Entity)this.brooklyn().getEntity(application, entity));
    }

    private List<EntitySummary> summaryForChildrenEntities(Entity rootEntity) {
        return Lists.newArrayList((Iterable)Iterables.transform((Iterable)rootEntity.getChildren(), (Function)new Function<Entity, EntitySummary>(){

            public EntitySummary apply(Entity entity) {
                return EntitySummary.fromEntity(entity);
            }
        }));
    }
}

