/*
 * Decompiled with CFR 0.152.
 */
package brooklyn.rest.resources;

import brooklyn.location.Location;
import brooklyn.location.LocationDefinition;
import brooklyn.location.basic.BasicLocationDefinition;
import brooklyn.rest.apidoc.Apidoc;
import brooklyn.rest.domain.LocationSpec;
import brooklyn.rest.domain.LocationSummary;
import brooklyn.rest.resources.AbstractBrooklynRestResource;
import brooklyn.rest.util.EntityLocationUtils;
import brooklyn.rest.util.WebResourceUtils;
import brooklyn.util.MutableMap;
import brooklyn.util.text.Identifiers;
import com.google.common.base.Function;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.wordnik.swagger.core.ApiOperation;
import com.wordnik.swagger.core.ApiParam;
import java.net.URI;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.validation.Valid;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;

@Path(value="/v1/locations")
@Apidoc(value="Locations")
@Produces(value={"application/json"})
public class LocationResource
extends AbstractBrooklynRestResource {
    @GET
    @ApiOperation(value="Fetch the list of locations", responseClass="brooklyn.rest.domain.LocationSummary", multiValueResponse=true)
    public List<LocationSummary> list() {
        return Lists.newArrayList((Iterable)Iterables.transform(this.brooklyn().getLocationRegistry().getDefinedLocations().values(), (Function)new Function<LocationDefinition, LocationSummary>(){

            public LocationSummary apply(LocationDefinition l) {
                return LocationResource.this.resolveLocationDefinition(l);
            }
        }));
    }

    protected LocationSummary resolveLocationDefinition(LocationDefinition l) {
        return LocationSummary.newInstance(l);
    }

    @GET
    @Path(value="/usage/LocatedLocations")
    @ApiOperation(value="Return a summary of all usage", notes="interim API, expected to change")
    public Map<String, Map<String, Object>> get() {
        LinkedHashMap<String, Map<String, Object>> result = new LinkedHashMap<String, Map<String, Object>>();
        Map<Location, Integer> counts = new EntityLocationUtils(this.mgmt()).countLeafEntitiesByLocatedLocations();
        for (Map.Entry<Location, Integer> count : counts.entrySet()) {
            Location l = count.getKey();
            MutableMap m = MutableMap.of((Object)"name", (Object)l.getName(), (Object)"leafEntityCount", (Object)count.getValue(), (Object)"latitude", (Object)l.getLocationProperty("latitude"), (Object)"longitude", (Object)l.getLocationProperty("longitude"));
            result.put(l.getId(), (Map<String, Object>)m);
        }
        return result;
    }

    @GET
    @Path(value="/{locationId}")
    @ApiOperation(value="Fetch details about a location", responseClass="brooklyn.rest.domain.LocationSummary", multiValueResponse=true)
    public LocationSummary get(@ApiParam(value="Location id to fetch", required=true) @PathParam(value="locationId") String locationId) {
        LocationDefinition l = this.brooklyn().getLocationRegistry().getDefinedLocation(locationId);
        if (l == null) {
            throw WebResourceUtils.notFound("No location matching %s", locationId);
        }
        return this.resolveLocationDefinition(l);
    }

    @POST
    @ApiOperation(value="Create a new location", responseClass="String")
    public Response create(@ApiParam(name="locationSpec", value="Location specification object", required=true) @Valid LocationSpec locationSpec) {
        String id = Identifiers.makeRandomId((int)8);
        BasicLocationDefinition l = new BasicLocationDefinition(id, locationSpec.getName(), locationSpec.getSpec(), locationSpec.getConfig());
        this.brooklyn().getLocationRegistry().updateDefinedLocation((LocationDefinition)l);
        return Response.created((URI)URI.create(id)).build();
    }

    @DELETE
    @Path(value="/{locationId}")
    @ApiOperation(value="Delete a location object by id")
    public void delete(@ApiParam(value="Location id to delete", required=true) @PathParam(value="locationId") String locationId) {
        this.brooklyn().getLocationRegistry().removeDefinedLocation(locationId);
    }
}

