/*
 * Decompiled with CFR 0.152.
 */
package brooklyn.rest.resources;

import brooklyn.config.ConfigKey;
import brooklyn.entity.Entity;
import brooklyn.entity.basic.EntityLocal;
import brooklyn.policy.Policy;
import brooklyn.rest.apidoc.Apidoc;
import brooklyn.rest.domain.PolicyConfigSummary;
import brooklyn.rest.resources.AbstractBrooklynRestResource;
import brooklyn.rest.util.WebResourceUtils;
import brooklyn.util.flags.TypeCoercions;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.wordnik.swagger.core.ApiError;
import com.wordnik.swagger.core.ApiErrors;
import com.wordnik.swagger.core.ApiOperation;
import com.wordnik.swagger.core.ApiParam;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Future;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;

@Path(value="/v1/applications/{application}/entities/{entity}/policies/{policy}/config")
@Apidoc(value="Policy config")
@Produces(value={"application/json"})
public class PolicyConfigResource
extends AbstractBrooklynRestResource {
    @GET
    @ApiOperation(value="Fetch the config keys for a specific policy", responseClass="brooklyn.rest.domain.ConfigSummary", multiValueResponse=true)
    @ApiErrors(value={@ApiError(code=404, reason="Could not find application or entity or policy")})
    public List<PolicyConfigSummary> list(@ApiParam(value="Application ID or name", required=true) @PathParam(value="application") String application, @ApiParam(value="Entity ID or name", required=true) @PathParam(value="entity") String entityToken, @ApiParam(value="Policy ID or name", required=true) @PathParam(value="policy") String policyToken) {
        EntityLocal entity = this.brooklyn().getEntity(application, entityToken);
        Policy policy = this.brooklyn().getPolicy((Entity)entity, policyToken);
        ArrayList result = Lists.newArrayList();
        for (ConfigKey key : policy.getPolicyType().getConfigKeys()) {
            result.add(new PolicyConfigSummary(entity, policy, key));
        }
        return result;
    }

    @GET
    @Path(value="/current-state")
    @ApiOperation(value="Fetch config key values in batch", notes="Returns a map of config name to value")
    public Map<String, Object> batchConfigRead(@ApiParam(value="Application ID or name", required=true) @PathParam(value="application") String application, @ApiParam(value="Entity ID or name", required=true) @PathParam(value="entity") String entityToken, @ApiParam(value="Policy ID or name", required=true) @PathParam(value="policy") String policyToken) {
        Policy policy = this.brooklyn().getPolicy(application, entityToken, policyToken);
        Map source = policy.getAllConfig();
        LinkedHashMap result = Maps.newLinkedHashMap();
        for (Map.Entry ek : source.entrySet()) {
            result.put(((ConfigKey)ek.getKey()).getName(), this.getValueForDisplay(policy, ek.getValue()));
        }
        return result;
    }

    @GET
    @Path(value="/{config}")
    @ApiOperation(value="Fetch config value", responseClass="Object")
    @ApiErrors(value={@ApiError(code=404, reason="Could not find application, entity, policy or config key")})
    public String get(@ApiParam(value="Application ID or name", required=true) @PathParam(value="application") String application, @ApiParam(value="Entity ID or name", required=true) @PathParam(value="entity") String entityToken, @ApiParam(value="Policy ID or name", required=true) @PathParam(value="policy") String policyToken, @ApiParam(value="Config key ID", required=true) @PathParam(value="config") String configKeyName) {
        Policy policy = this.brooklyn().getPolicy(application, entityToken, policyToken);
        ConfigKey ck = policy.getPolicyType().getConfigKey(configKeyName);
        if (ck == null) {
            throw WebResourceUtils.notFound("Cannot find config key '%s' in policy '%s' of entity '%s'", configKeyName, policy, entityToken);
        }
        return this.getValueForDisplay(policy, policy.getConfig(ck));
    }

    @POST
    @Path(value="/{config}/set")
    @ApiOperation(value="Sets the given config on this policy")
    @ApiErrors(value={@ApiError(code=404, reason="Could not find application, entity, policy or config key")})
    public Response set(@ApiParam(value="Application ID or name", required=true) @PathParam(value="application") String application, @ApiParam(value="Entity ID or name", required=true) @PathParam(value="entity") String entityToken, @ApiParam(value="Policy ID or name", required=true) @PathParam(value="policy") String policyToken, @ApiParam(value="Config key ID", required=true) @PathParam(value="config") String configKeyName, @ApiParam(name="value", value="New value for the configuration", required=true) @QueryParam(value="value") String value) {
        Policy policy = this.brooklyn().getPolicy(application, entityToken, policyToken);
        ConfigKey ck = policy.getPolicyType().getConfigKey(configKeyName);
        if (ck == null) {
            throw WebResourceUtils.notFound("Cannot find config key '%s' in policy '%s' of entity '%s'", configKeyName, policy, entityToken);
        }
        policy.setConfig(ck, TypeCoercions.coerce((Object)value, (Class)ck.getType()));
        return Response.status((Response.Status)Response.Status.OK).build();
    }

    private String getValueForDisplay(Policy policy, Object value) {
        if (value instanceof Future && ((Future)value).isDone()) {
            try {
                value = ((Future)value).get();
            }
            catch (Exception e) {
                value = value + " (error evaluating: " + e + ")";
            }
        }
        return value != null ? value.toString() : null;
    }
}

