/*
 * Decompiled with CFR 0.152.
 */
package brooklyn.rest.resources;

import brooklyn.entity.Entity;
import brooklyn.entity.basic.EntityLocal;
import brooklyn.entity.basic.Lifecycle;
import brooklyn.policy.Policy;
import brooklyn.policy.basic.Policies;
import brooklyn.rest.apidoc.Apidoc;
import brooklyn.rest.domain.PolicySummary;
import brooklyn.rest.resources.AbstractBrooklynRestResource;
import brooklyn.util.exceptions.Exceptions;
import com.google.common.base.Function;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.wordnik.swagger.core.ApiError;
import com.wordnik.swagger.core.ApiErrors;
import com.wordnik.swagger.core.ApiOperation;
import com.wordnik.swagger.core.ApiParam;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="/v1/applications/{application}/entities/{entity}/policies")
@Apidoc(value="Entity policies")
@Produces(value={"application/json"})
public class PolicyResource
extends AbstractBrooklynRestResource {
    private static final Logger log = LoggerFactory.getLogger(PolicyResource.class);

    @GET
    @ApiOperation(value="Fetch the policies attached to a specific application entity", responseClass="brooklyn.rest.domain.PolicySummary", multiValueResponse=true)
    @ApiErrors(value={@ApiError(code=404, reason="Could not find application or entity")})
    public List<PolicySummary> list(@ApiParam(value="Application ID or name", required=true) @PathParam(value="application") String application, @ApiParam(value="Entity ID or name", required=true) @PathParam(value="entity") String entityToken) {
        EntityLocal entity = this.brooklyn().getEntity(application, entityToken);
        return Lists.newArrayList((Iterable)Iterables.transform((Iterable)entity.getPolicies(), (Function)new Function<Policy, PolicySummary>((Entity)entity){
            private final /* synthetic */ Entity val$entity;
            {
                this.val$entity = entity;
            }

            public PolicySummary apply(Policy policy) {
                return PolicySummary.fromEntity(this.val$entity, policy);
            }
        }));
    }

    @GET
    @Path(value="/current-state")
    @ApiOperation(value="Fetch policy states in batch", notes="Returns a map of policy ID to whether it is active")
    public Map<String, Boolean> batchConfigRead(@ApiParam(value="Application ID or name", required=true) @PathParam(value="application") String application, @ApiParam(value="Entity ID or name", required=true) @PathParam(value="entity") String entityToken) {
        EntityLocal entity = this.brooklyn().getEntity(application, entityToken);
        LinkedHashMap result = Maps.newLinkedHashMap();
        for (Policy p : entity.getPolicies()) {
            result.put(p.getId(), !p.isSuspended());
        }
        return result;
    }

    @POST
    @ApiOperation(value="Add a policy", notes="Returns ID of policy added; policy type must have no-arg constructor and setConfig(Map) method should be available if non-empty config is supplied")
    @ApiErrors(value={@ApiError(code=404, reason="Could not find application, entity or policy")})
    public String addPolicy(@ApiParam(name="application", value="Application ID or name", required=true) @PathParam(value="application") String application, @ApiParam(name="entity", value="Entity ID or name", required=true) @PathParam(value="entity") String entityToken, @ApiParam(name="policyType", value="Class of policy to add", required=true) @QueryParam(value="type") String policyTypeName, @ApiParam(name="config", value="Configuration for the policy (as key value pairs)", required=true) Map<String, String> config) {
        EntityLocal entity = this.brooklyn().getEntity(application, entityToken);
        try {
            Class<?> policyType = Class.forName(policyTypeName);
            Policy policy = (Policy)policyType.newInstance();
            if (config != null && !config.isEmpty()) {
                policyType.getMethod("setConfig", Map.class).invoke((Object)policy, config);
            }
            log.debug("REST API adding policy " + policy + " to " + entity);
            entity.addPolicy(policy);
            return policy.getId();
        }
        catch (Exception e) {
            throw Exceptions.propagate((Throwable)e);
        }
    }

    @GET
    @Path(value="/{policy}")
    @ApiOperation(value="Gets status of a policy (RUNNING / SUSPENDED)")
    @ApiErrors(value={@ApiError(code=404, reason="Could not find application, entity or policy")})
    public Lifecycle getStatus(@ApiParam(name="application", value="Application ID or name", required=true) @PathParam(value="application") String application, @ApiParam(name="entity", value="Entity ID or name", required=true) @PathParam(value="entity") String entityToken, @ApiParam(name="policy", value="Policy ID or name", required=true) @PathParam(value="policy") String policyId) {
        Policy policy = this.brooklyn().getPolicy(application, entityToken, policyId);
        return Policies.getPolicyStatus((Policy)policy);
    }

    @POST
    @Path(value="/{policy}/start")
    @ApiOperation(value="Start or resume a policy")
    @ApiErrors(value={@ApiError(code=404, reason="Could not find application, entity or policy")})
    public Response start(@ApiParam(name="application", value="Application ID or name", required=true) @PathParam(value="application") String application, @ApiParam(name="entity", value="Entity ID or name", required=true) @PathParam(value="entity") String entityToken, @ApiParam(name="policy", value="Policy ID or name", required=true) @PathParam(value="policy") String policyId) {
        Policy policy = this.brooklyn().getPolicy(application, entityToken, policyId);
        policy.resume();
        return Response.status((Response.Status)Response.Status.OK).build();
    }

    @POST
    @Path(value="/{policy}/stop")
    @ApiOperation(value="Suspends a policy")
    @ApiErrors(value={@ApiError(code=404, reason="Could not find application, entity or policy")})
    public Response stop(@ApiParam(name="application", value="Application ID or name", required=true) @PathParam(value="application") String application, @ApiParam(name="entity", value="Entity ID or name", required=true) @PathParam(value="entity") String entityToken, @ApiParam(name="policy", value="Policy ID or name", required=true) @PathParam(value="policy") String policyId) {
        Policy policy = this.brooklyn().getPolicy(application, entityToken, policyId);
        policy.suspend();
        return Response.status((Response.Status)Response.Status.OK).build();
    }

    @POST
    @Path(value="/{policy}/destroy")
    @ApiOperation(value="Destroy a policy", notes="Removes a policy from being associated with the entity and destroys it (stopping first if running)")
    @ApiErrors(value={@ApiError(code=404, reason="Could not find application, entity or policy")})
    public Response destroy(@ApiParam(name="application", value="Application ID or name", required=true) @PathParam(value="application") String application, @ApiParam(name="entity", value="Entity ID or name", required=true) @PathParam(value="entity") String entityToken, @ApiParam(name="policy", value="Policy ID or name", required=true) @PathParam(value="policy") String policyToken) {
        EntityLocal entity = this.brooklyn().getEntity(application, entityToken);
        Policy policy = this.brooklyn().getPolicy((Entity)entity, policyToken);
        policy.suspend();
        entity.removePolicy(policy);
        return Response.status((Response.Status)Response.Status.OK).build();
    }
}

