/*
 * Decompiled with CFR 0.152.
 */
package brooklyn.rest.resources;

import brooklyn.rest.apidoc.Apidoc;
import brooklyn.rest.domain.ScriptExecutionSummary;
import brooklyn.rest.resources.AbstractBrooklynRestResource;
import brooklyn.util.stream.ThreadLocalPrintStream;
import com.wordnik.swagger.core.ApiOperation;
import com.wordnik.swagger.core.ApiParam;
import groovy.lang.Binding;
import groovy.lang.GroovyShell;
import java.util.LinkedHashMap;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="/v1/script")
@Apidoc(value="Script")
@Produces(value={"application/json"})
public class ScriptResource
extends AbstractBrooklynRestResource {
    private static final Logger log = LoggerFactory.getLogger(ScriptResource.class);
    public static final String USER_DATA_MAP_SESSION_ATTRIBUTE = "brooklyn.script.groovy.user.data";
    public static final String USER_LAST_VALUE_SESSION_ATTRIBUTE = "brooklyn.script.groovy.user.last";

    @POST
    @Path(value="/groovy")
    @ApiOperation(value="Execute a groovy script", responseClass="brooklyn.rest.domain.SensorSummary")
    public ScriptExecutionSummary groovy(@Context HttpServletRequest request, @ApiParam(name="script", value="Groovy script to execute", required=true) String script) {
        Throwable problem;
        Object value;
        ThreadLocalPrintStream.OutputCapturingContext stderr;
        ThreadLocalPrintStream.OutputCapturingContext stdout;
        block10: {
            HttpSession session;
            log.info("Web REST executing user-supplied script");
            if (log.isDebugEnabled()) {
                log.debug("Web REST user-supplied script contents:\n" + script);
            }
            Binding binding = new Binding();
            binding.setVariable("mgmt", (Object)this.mgmt());
            HttpSession httpSession = session = request != null ? request.getSession() : null;
            if (session != null) {
                LinkedHashMap data = (LinkedHashMap)session.getAttribute(USER_DATA_MAP_SESSION_ATTRIBUTE);
                if (data == null) {
                    data = new LinkedHashMap();
                    session.setAttribute(USER_DATA_MAP_SESSION_ATTRIBUTE, data);
                }
                binding.setVariable("data", data);
                Object last = session.getAttribute(USER_LAST_VALUE_SESSION_ATTRIBUTE);
                binding.setVariable("last", last);
            }
            GroovyShell shell = new GroovyShell(binding);
            stdout = ThreadLocalPrintStream.stdout().capture();
            stderr = ThreadLocalPrintStream.stderr().capture();
            value = null;
            problem = null;
            try {
                try {
                    value = shell.evaluate(script);
                    if (session != null) {
                        session.setAttribute(USER_LAST_VALUE_SESSION_ATTRIBUTE, value);
                    }
                }
                catch (Throwable t) {
                    problem = t;
                    stdout.end();
                    stderr.end();
                    break block10;
                }
            }
            catch (Throwable throwable) {
                stdout.end();
                stderr.end();
                throw throwable;
            }
            stdout.end();
            stderr.end();
        }
        if (log.isDebugEnabled()) {
            log.debug("Web REST user-supplied script completed:\n" + (value != null ? "RESULT: " + value.toString() + "\n" : "") + (problem != null ? "ERROR: " + problem.toString() + "\n" : "") + (!stdout.isEmpty() ? "STDOUT: " + stdout.toString() + "\n" : "") + (!stderr.isEmpty() ? "STDERR: " + stderr.toString() + "\n" : ""));
        }
        return new ScriptExecutionSummary(value != null ? value.toString() : null, problem != null ? problem.toString() : null, stdout.toString(), stderr.toString());
    }
}

