/*
 * Decompiled with CFR 0.152.
 */
package brooklyn.rest.resources;

import brooklyn.entity.basic.EntityLocal;
import brooklyn.event.AttributeSensor;
import brooklyn.event.Sensor;
import brooklyn.event.basic.BasicAttributeSensor;
import brooklyn.rest.apidoc.Apidoc;
import brooklyn.rest.domain.SensorSummary;
import brooklyn.rest.resources.AbstractBrooklynRestResource;
import brooklyn.rest.util.JsonUtils;
import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.wordnik.swagger.core.ApiError;
import com.wordnik.swagger.core.ApiErrors;
import com.wordnik.swagger.core.ApiOperation;
import com.wordnik.swagger.core.ApiParam;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;

@Path(value="/v1/applications/{application}/entities/{entity}/sensors")
@Apidoc(value="Entity sensors")
@Produces(value={"application/json"})
public class SensorResource
extends AbstractBrooklynRestResource {
    @GET
    @ApiOperation(value="Fetch the sensor list for a specific application entity", responseClass="brooklyn.rest.domain.SensorSummary", multiValueResponse=true)
    @ApiErrors(value={@ApiError(code=404, reason="Could not find application or entity")})
    public List<SensorSummary> list(@ApiParam(value="Application ID or name", required=true) @PathParam(value="application") String application, @ApiParam(value="Entity ID or name", required=true) @PathParam(value="entity") String entityToken) {
        final EntityLocal entity = this.brooklyn().getEntity(application, entityToken);
        return Lists.newArrayList((Iterable)Iterables.transform((Iterable)Iterables.filter((Iterable)entity.getEntityType().getSensors(), (Predicate)new Predicate<Sensor<?>>(){

            public boolean apply(@Nullable Sensor<?> input) {
                return input instanceof AttributeSensor;
            }
        }), (Function)new Function<Sensor<?>, SensorSummary>(){

            public SensorSummary apply(Sensor<?> sensor) {
                return SensorSummary.fromEntity(entity, sensor);
            }
        }));
    }

    @GET
    @Path(value="/current-state")
    @ApiOperation(value="Fetch sensor values in batch", notes="Returns a map of sensor name to value")
    public Map<String, Object> batchSensorRead(@ApiParam(value="Application ID or name", required=true) @PathParam(value="application") String application, @ApiParam(value="Entity ID or name", required=true) @PathParam(value="entity") String entityToken) {
        EntityLocal entity = this.brooklyn().getEntity(application, entityToken);
        HashMap sensorMap = Maps.newHashMap();
        ArrayList sensors = Lists.newArrayList((Iterable)Iterables.filter((Iterable)entity.getEntityType().getSensors(), (Predicate)new Predicate<Sensor<?>>(){

            public boolean apply(@Nullable Sensor<?> input) {
                return input instanceof AttributeSensor;
            }
        }));
        for (Sensor sensor : sensors) {
            Object value = entity.getAttribute(this.findSensor(entity, sensor.getName()));
            sensorMap.put(sensor.getName(), JsonUtils.toJsonable(value));
        }
        return sensorMap;
    }

    @GET
    @Path(value="/{sensor}")
    @ApiOperation(value="Fetch sensor value", responseClass="String")
    @ApiErrors(value={@ApiError(code=404, reason="Could not find application, entity or sensor")})
    @Produces(value={"text/plain"})
    public String get(@ApiParam(value="Application ID or name", required=true) @PathParam(value="application") String application, @ApiParam(value="Entity ID or name", required=true) @PathParam(value="entity") String entityToken, @ApiParam(value="Sensor name", required=true) @PathParam(value="sensor") String sensorName) {
        EntityLocal entity = this.brooklyn().getEntity(application, entityToken);
        Object value = entity.getAttribute(this.findSensor(entity, sensorName));
        return value != null ? value.toString() : "";
    }

    private AttributeSensor<?> findSensor(EntityLocal entity, String name) {
        Sensor s = entity.getEntityType().getSensor(name);
        if (s instanceof AttributeSensor) {
            return (AttributeSensor)s;
        }
        return new BasicAttributeSensor(Object.class, name);
    }
}

