/*
 * Decompiled with CFR 0.152.
 */
package brooklyn.rest.security;

import brooklyn.config.BrooklynServiceAttributes;
import brooklyn.management.ManagementContext;
import brooklyn.rest.security.provider.DelegatingSecurityProvider;
import com.sun.jersey.core.util.Base64;
import java.io.IOException;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BrooklynPropertiesSecurityFilter
implements Filter {
    public static final String AUTHENTICATED_USER_SESSION_ATTRIBUTE = "brooklyn.user";
    private static final Logger log = LoggerFactory.getLogger(BrooklynPropertiesSecurityFilter.class);
    protected ManagementContext mgmt;
    protected DelegatingSecurityProvider provider;

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        if (this.provider == null) {
            log.warn("No security provider available: disallowing web access to brooklyn");
            ((HttpServletResponse)response).sendError(503);
            return;
        }
        if (this.authenticate((HttpServletRequest)request) && !this.handleLogout((HttpServletRequest)request)) {
            chain.doFilter(request, response);
            return;
        }
        ((HttpServletResponse)response).setHeader("WWW-Authenticate", "Basic realm=\"brooklyn\"");
        ((HttpServletResponse)response).sendError(401);
    }

    protected boolean authenticate(HttpServletRequest request) {
        if (this.provider.isAuthenticated(request.getSession())) {
            return true;
        }
        String user = null;
        String pass = null;
        String authorization = request.getHeader("Authorization");
        if (authorization != null) {
            String userpass = Base64.base64Decode((String)authorization.substring(6));
            user = userpass.substring(0, userpass.indexOf(":"));
            pass = userpass.substring(userpass.indexOf(":") + 1);
        }
        if (this.provider.authenticate(request.getSession(), user, pass)) {
            log.debug("Web API authenticated " + request.getSession() + " for user " + user);
            if (user != null) {
                request.getSession().setAttribute(AUTHENTICATED_USER_SESSION_ATTRIBUTE, (Object)user);
            }
            return true;
        }
        return false;
    }

    public void init(FilterConfig config) throws ServletException {
        this.mgmt = (ManagementContext)config.getServletContext().getAttribute(BrooklynServiceAttributes.BROOKLYN_MANAGEMENT_CONTEXT);
        this.provider = new DelegatingSecurityProvider(this.mgmt);
    }

    public void destroy() {
    }

    protected boolean handleLogout(HttpServletRequest request) {
        if ("/logout".equals(request.getRequestURI()) || "/v1/logout".equals(request.getRequestURI())) {
            log.info("Web API logging out " + request.getSession() + " for user " + request.getSession().getAttribute(AUTHENTICATED_USER_SESSION_ATTRIBUTE));
            this.provider.logout(request.getSession());
            request.getSession().removeAttribute(AUTHENTICATED_USER_SESSION_ATTRIBUTE);
            request.getSession().invalidate();
            return true;
        }
        return false;
    }
}

