/*
 * Decompiled with CFR 0.152.
 */
package brooklyn.rest.security.provider;

import brooklyn.config.StringConfigMap;
import brooklyn.management.ManagementContext;
import brooklyn.rest.BrooklynWebConfig;
import brooklyn.rest.security.provider.BlackholeSecurityProvider;
import brooklyn.rest.security.provider.SecurityProvider;
import brooklyn.util.text.Strings;
import java.lang.reflect.Constructor;
import javax.servlet.http.HttpSession;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DelegatingSecurityProvider
implements SecurityProvider {
    public static final Logger log = LoggerFactory.getLogger(DelegatingSecurityProvider.class);
    protected final ManagementContext mgmt;
    private SecurityProvider targetProvider;

    public DelegatingSecurityProvider(ManagementContext mgmt) {
        this.mgmt = mgmt;
    }

    public synchronized SecurityProvider getTargetProvider() {
        if (this.targetProvider != null) {
            return this.targetProvider;
        }
        StringConfigMap brooklynProperties = this.mgmt.getConfig();
        String className = (String)brooklynProperties.getConfig(BrooklynWebConfig.SECURITY_PROVIDER_CLASSNAME);
        log.info("Web console using security provider " + className);
        try {
            Class<?> clazz;
            try {
                clazz = Class.forName(className);
            }
            catch (Exception e) {
                String OLD_PACKAGE = "brooklyn.web.console.security.";
                if (className.startsWith(OLD_PACKAGE)) {
                    className = Strings.removeFromStart((String)className, (String[])new String[]{OLD_PACKAGE});
                    className = String.valueOf(DelegatingSecurityProvider.class.getPackage().getName()) + "." + className;
                    clazz = Class.forName(className);
                    log.warn("Deprecated package " + OLD_PACKAGE + " detected; please update security provider to point to " + className);
                }
                throw e;
            }
            try {
                Constructor<?> constructor = clazz.getConstructor(ManagementContext.class);
                this.targetProvider = (SecurityProvider)constructor.newInstance(this.mgmt);
            }
            catch (Exception exception) {
                Constructor<?> constructor = clazz.getConstructor(new Class[0]);
                this.targetProvider = (SecurityProvider)constructor.newInstance(new Object[0]);
            }
        }
        catch (Exception e) {
            log.warn("Web console unable to instantiate security provider " + className + "; all logins are being disallowed", (Throwable)e);
            this.targetProvider = new BlackholeSecurityProvider();
        }
        return this.targetProvider;
    }

    @Override
    public boolean isAuthenticated(HttpSession session) {
        return this.getTargetProvider().isAuthenticated(session);
    }

    @Override
    public boolean authenticate(HttpSession session, String user, String password) {
        return this.getTargetProvider().authenticate(session, user, password);
    }

    @Override
    public boolean logout(HttpSession session) {
        return this.getTargetProvider().logout(session);
    }
}

