/*
 * Decompiled with CFR 0.152.
 */
package brooklyn.rest.security.provider;

import brooklyn.config.BrooklynProperties;
import brooklyn.config.StringConfigMap;
import brooklyn.management.ManagementContext;
import brooklyn.rest.BrooklynWebConfig;
import brooklyn.rest.security.provider.AnyoneSecurityProvider;
import brooklyn.rest.security.provider.SecurityProvider;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.StringTokenizer;
import javax.servlet.http.HttpSession;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExplicitUsersSecurityProvider
implements SecurityProvider {
    public static final Logger LOG = LoggerFactory.getLogger(ExplicitUsersSecurityProvider.class);
    public static final String AUTHENTICATION_KEY = String.valueOf(ExplicitUsersSecurityProvider.class.getCanonicalName()) + "." + "AUTHENTICATED";
    protected final ManagementContext mgmt;
    private boolean allowAnyUserWithValidPass = false;
    private boolean allowDefaultUsers = false;
    private boolean allowAnyUser = false;
    private Set<String> allowedUsers = null;

    public ExplicitUsersSecurityProvider(ManagementContext mgmt) {
        this.mgmt = mgmt;
    }

    @Override
    public boolean isAuthenticated(HttpSession session) {
        if (session == null) {
            return false;
        }
        if (this.allowAnyUser) {
            return true;
        }
        Object value = session.getAttribute(AUTHENTICATION_KEY);
        return value != null;
    }

    private synchronized void initialize() {
        if (this.allowedUsers != null) {
            return;
        }
        StringConfigMap properties = this.mgmt.getConfig();
        this.allowedUsers = new LinkedHashSet<String>();
        String users = (String)properties.getConfig(BrooklynWebConfig.SECURITY_PROVIDER_EXPLICIT__USERS);
        if (users == null) {
            LOG.info("Web console allowing default user (admin)");
            this.allowDefaultUsers = true;
        } else if ("*".equals(users)) {
            LOG.info("Web console allowing any users");
            this.allowAnyUserWithValidPass = true;
        } else {
            LOG.info("Web console allowing users " + users);
            StringTokenizer t = new StringTokenizer(users, ",");
            while (t.hasMoreElements()) {
                this.allowedUsers.add(("" + t.nextElement()).trim());
            }
        }
        if (properties.getFirst(new String[]{"brooklyn.autologin.username"}) != null) {
            LOG.warn("Use of legacy AUTOLOGIN; replace with setting BrooklynSystemProperties.SECURITY_PROVIDER to " + AnyoneSecurityProvider.class.getCanonicalName());
            this.allowAnyUser = true;
        }
    }

    @Override
    public boolean authenticate(HttpSession session, String user, String password) {
        BrooklynProperties properties;
        String actualP;
        if (this.allowAnyUser) {
            return true;
        }
        if (session == null || user == null) {
            return false;
        }
        this.initialize();
        if (!this.allowAnyUserWithValidPass) {
            if (this.allowDefaultUsers && user.equals("admin") && password.equals("password")) {
                return this.allow(session, user);
            }
            if (!this.allowedUsers.contains(user)) {
                LOG.info("Web console rejecting unknown user " + user);
                return false;
            }
        }
        if ((actualP = (String)(properties = (BrooklynProperties)this.mgmt.getConfig()).getConfig(BrooklynWebConfig.SECURITY_PROVIDER_EXPLICIT__PASSWORD(user))) == null) {
            LOG.info("Web console rejecting passwordless user " + user);
            return false;
        }
        if (!actualP.equals(password)) {
            LOG.info("Web console rejecting bad password for user " + user);
            return false;
        }
        return this.allow(session, user);
    }

    private boolean allow(HttpSession session, String user) {
        LOG.debug("Web console " + this.getClass().getSimpleName() + " authenticated user " + user);
        session.setAttribute(AUTHENTICATION_KEY, (Object)user);
        return true;
    }

    @Override
    public boolean logout(HttpSession session) {
        if (session == null) {
            return false;
        }
        session.removeAttribute(AUTHENTICATION_KEY);
        return true;
    }
}

