/*
 * Decompiled with CFR 0.152.
 */
package brooklyn.rest.util;

import brooklyn.catalog.BrooklynCatalog;
import brooklyn.catalog.CatalogItem;
import brooklyn.entity.Application;
import brooklyn.entity.Effector;
import brooklyn.entity.Entity;
import brooklyn.entity.basic.AbstractEntity;
import brooklyn.entity.basic.ApplicationBuilder;
import brooklyn.entity.basic.BasicApplication;
import brooklyn.entity.basic.Entities;
import brooklyn.entity.basic.EntityInternal;
import brooklyn.entity.basic.EntityLocal;
import brooklyn.entity.basic.EntityTypes;
import brooklyn.entity.proxying.BasicEntitySpec;
import brooklyn.entity.proxying.EntitySpec;
import brooklyn.entity.proxying.EntitySpecs;
import brooklyn.entity.trait.Startable;
import brooklyn.location.Location;
import brooklyn.location.LocationRegistry;
import brooklyn.management.ManagementContext;
import brooklyn.management.Task;
import brooklyn.policy.Policy;
import brooklyn.policy.basic.AbstractPolicy;
import brooklyn.rest.domain.ApplicationSpec;
import brooklyn.rest.util.WebResourceUtils;
import brooklyn.util.MutableMap;
import brooklyn.util.exceptions.Exceptions;
import brooklyn.util.text.Strings;
import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import groovy.lang.GroovyClassLoader;
import java.lang.reflect.Constructor;
import java.net.URI;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.NoSuchElementException;
import javax.ws.rs.core.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BrooklynRestResourceUtils {
    private static final Logger log = LoggerFactory.getLogger(BrooklynRestResourceUtils.class);
    private final ManagementContext mgmt;

    public BrooklynRestResourceUtils(ManagementContext mgmt) {
        Preconditions.checkNotNull((Object)mgmt, (Object)"mgmt");
        this.mgmt = mgmt;
    }

    public BrooklynCatalog getCatalog() {
        return this.mgmt.getCatalog();
    }

    public LocationRegistry getLocationRegistry() {
        return this.mgmt.getLocationRegistry();
    }

    public Policy getPolicy(String application, String entity, String policy) {
        return this.getPolicy((Entity)this.getEntity(application, entity), policy);
    }

    public Policy getPolicy(Entity entity, String policy) {
        if (policy == null) {
            return null;
        }
        for (Policy p : entity.getPolicies()) {
            if (!policy.equals(p.getId())) continue;
            return p;
        }
        for (Policy p : entity.getPolicies()) {
            if (!policy.equals(p.getName())) continue;
            return p;
        }
        throw WebResourceUtils.notFound("Cannot find policy '%s' in entity '%s'", policy, entity);
    }

    public EntityLocal getEntity(String application, String entity) {
        if (entity == null) {
            return null;
        }
        Application app = application != null ? this.getApplication(application) : null;
        EntityLocal e = (EntityLocal)this.mgmt.getEntityManager().getEntity(entity);
        if (e != null) {
            if (app == null || app.equals(this.findTopLevelApplication((Entity)e))) {
                return e;
            }
            throw WebResourceUtils.preconditionFailed("Application '%s' specified does not match application '%s' to which entity '%s' (%s) is associated", application, e.getApplication().getId(), entity, e);
        }
        if (application == null) {
            throw WebResourceUtils.notFound("Cannot find entity '%s': no known ID and application not supplied for searching", entity);
        }
        assert (app != null) : "null app should not be returned from getApplication";
        e = this.searchForEntityNamed((Entity)app, entity);
        if (e != null) {
            return e;
        }
        throw WebResourceUtils.notFound("Cannot find entity '%s' in application '%s' (%s)", entity, application, app);
    }

    private Application findTopLevelApplication(Entity e) {
        Application app = e.getApplication();
        while (app != null && !app.equals(app.getApplication())) {
            app = app.getApplication();
        }
        return app;
    }

    public Application getApplication(String application) {
        Entity e = this.mgmt.getEntityManager().getEntity(application);
        if (e != null && e instanceof Application) {
            return (Application)e;
        }
        for (Application app : this.mgmt.getApplications()) {
            if (app.getId().equals(application)) {
                return app;
            }
            if (!application.equalsIgnoreCase(app.getDisplayName())) continue;
            return app;
        }
        throw WebResourceUtils.notFound("Application '%s' not found", application);
    }

    public EntityLocal searchForEntityNamed(Entity root, String entity) {
        if (root.getId().equals(entity) || entity.equals(root.getDisplayName())) {
            return (EntityLocal)root;
        }
        for (Entity child : root.getChildren()) {
            EntityLocal result = this.searchForEntityNamed(child, entity);
            if (result == null) continue;
            return result;
        }
        return null;
    }

    public Application create(ApplicationSpec spec) {
        Class<?> clazz;
        Object entities;
        log.debug("REST creating application instance for {}", (Object)spec);
        String type = spec.getType();
        String name = spec.getName();
        Map<String, String> configO = spec.getConfig();
        Object object = entities = spec.getEntities() == null ? ImmutableSet.of() : spec.getEntities();
        if (Strings.isEmpty((CharSequence)type)) {
            clazz = BasicApplication.class;
        } else {
            Class<?> tempclazz;
            try {
                tempclazz = this.getCatalog().loadClassByType(type, Entity.class);
            }
            catch (NoSuchElementException e) {
                try {
                    tempclazz = this.getCatalog().getRootClassLoader().loadClass(type);
                    log.info("Catalog does not contain item for type {}; loaded class directly instead", (Object)type);
                }
                catch (ClassNotFoundException classNotFoundException) {
                    log.warn("No catalog item for type {}, and could not load class directly; rethrowing", (Object)type);
                    throw e;
                }
            }
            clazz = tempclazz;
        }
        try {
            EntitySpec<?> coreSpec;
            Application instance;
            if (ApplicationBuilder.class.isAssignableFrom(clazz)) {
                Constructor<?> constructor = clazz.getConstructor(new Class[0]);
                ApplicationBuilder appBuilder = (ApplicationBuilder)constructor.newInstance(new Object[0]);
                if (!Strings.isEmpty((CharSequence)name)) {
                    appBuilder.appDisplayName(name);
                }
                if (entities.size() > 0) {
                    log.warn("Cannot supply additional entities when using an ApplicationBuilder; ignoring in spec {}", (Object)spec);
                }
                log.info("REST placing '{}' under management", (Object)spec.getName());
                appBuilder.configure(this.convertFlagsToKeys(appBuilder.getType(), configO));
                instance = appBuilder.manage(this.mgmt);
            } else if (Application.class.isAssignableFrom(clazz)) {
                coreSpec = this.toCoreEntitySpec(clazz, name, configO);
                instance = (Application)this.mgmt.getEntityManager().createEntity(coreSpec);
                Iterator iterator = entities.iterator();
                while (iterator.hasNext()) {
                    brooklyn.rest.domain.EntitySpec entitySpec = (brooklyn.rest.domain.EntitySpec)iterator.next();
                    log.info("REST creating instance for entity {}", (Object)entitySpec.getType());
                    instance.addChild(this.mgmt.getEntityManager().createEntity(this.toCoreEntitySpec(entitySpec)));
                }
                log.info("REST placing '{}' under management", (Object)spec.getName());
                Entities.startManagement((Application)instance, (ManagementContext)this.mgmt);
            } else if (Entity.class.isAssignableFrom(clazz)) {
                if (entities.size() > 0) {
                    log.warn("Cannot supply additional entities when using a non-application entity; ignoring in spec {}", (Object)spec);
                }
                coreSpec = this.toCoreEntitySpec(BasicApplication.class, name, configO);
                instance = (Application)this.mgmt.getEntityManager().createEntity(coreSpec);
                Class eclazz = this.getCatalog().loadClassByType(spec.getType(), Entity.class);
                instance.addChild(this.mgmt.getEntityManager().createEntity(this.toCoreEntitySpec(eclazz, name, configO)));
                log.info("REST placing '{}' under management", (Object)spec.getName());
                Entities.startManagement((Application)instance, (ManagementContext)this.mgmt);
            } else {
                throw new IllegalArgumentException("Class " + clazz + " must extend one of ApplicationBuilder, Application or Entity");
            }
            return instance;
        }
        catch (Exception e) {
            log.error("REST failed to create application: " + e, (Throwable)e);
            throw Exceptions.propagate((Throwable)e);
        }
    }

    public Task<?> start(Application app, ApplicationSpec spec) {
        Function<String, Location> buildLocationFromId = new Function<String, Location>(){

            public Location apply(String id) {
                id = BrooklynRestResourceUtils.fixLocation(id);
                return BrooklynRestResourceUtils.this.getLocationRegistry().resolve(id);
            }
        };
        ArrayList locations = Lists.newArrayList((Iterable)Iterables.transform(spec.getLocations(), (Function)buildLocationFromId));
        return Entities.invokeEffectorWithMap((EntityLocal)((EntityLocal)app), (Entity)app, (Effector)Startable.START, (Map)MutableMap.of((Object)"locations", (Object)locations));
    }

    private EntitySpec<? extends Entity> toCoreEntitySpec(brooklyn.rest.domain.EntitySpec spec) {
        String type = spec.getType();
        String name = spec.getName();
        LinkedHashMap config = spec.getConfig() == null ? Maps.newLinkedHashMap() : Maps.newLinkedHashMap(spec.getConfig());
        Class clazz = this.getCatalog().loadClassByType(type, Entity.class);
        BasicEntitySpec result = clazz.isInterface() ? EntitySpecs.spec((Class)clazz) : EntitySpecs.spec(Entity.class).impl(clazz);
        if (!Strings.isEmpty((CharSequence)name)) {
            result.displayName(name);
        }
        result.configure(this.convertFlagsToKeys(result.getType(), config));
        return result;
    }

    private <T extends Entity> EntitySpec<?> toCoreEntitySpec(Class<T> clazz, String name, Map<String, String> configO) {
        BasicEntitySpec result;
        LinkedHashMap config;
        LinkedHashMap linkedHashMap = config = configO == null ? Maps.newLinkedHashMap() : Maps.newLinkedHashMap(configO);
        if (clazz.isInterface()) {
            result = EntitySpecs.spec(clazz);
        } else {
            Class interfaceclazz = Application.class.isAssignableFrom(clazz) ? Application.class : Entity.class;
            Class[] additionalInterfaceClazzes = clazz.getInterfaces();
            result = EntitySpecs.spec(interfaceclazz).impl(clazz).additionalInterfaces(additionalInterfaceClazzes);
        }
        if (!Strings.isEmpty((CharSequence)name)) {
            result.displayName(name);
        }
        result.configure(this.convertFlagsToKeys(result.getImplementation(), config));
        return result;
    }

    private Map<?, ?> convertFlagsToKeys(Class<? extends Entity> javaType, Map<?, ?> config) {
        if (config == null || config.isEmpty() || javaType == null) {
            return config;
        }
        Map configKeys = EntityTypes.getDefinedConfigKeys(javaType);
        LinkedHashMap result = new LinkedHashMap();
        for (Map.Entry<?, ?> entry : config.entrySet()) {
            log.debug("Setting key {} to {} for REST creation of {}", new Object[]{entry.getKey(), entry.getValue(), javaType});
            Object key = configKeys.get(entry.getKey());
            if (key == null) {
                log.warn("Unrecognised config key {} passed to {}; will be treated as flag (and likely ignored)", entry.getKey(), javaType);
                key = entry.getKey();
            }
            result.put(key, entry.getValue());
        }
        return result;
    }

    public Task<?> destroy(final Application application) {
        return this.mgmt.getExecutionManager().submit(new Runnable(){

            @Override
            public void run() {
                ((EntityInternal)application).destroy();
                BrooklynRestResourceUtils.this.mgmt.getEntityManager().unmanage((Entity)application);
            }
        });
    }

    public Response createCatalogEntryFromGroovyCode(String groovyCode) {
        ClassLoader parent = this.getCatalog().getRootClassLoader();
        GroovyClassLoader loader = new GroovyClassLoader(parent);
        Class clazz = loader.parseClass(groovyCode);
        if (AbstractEntity.class.isAssignableFrom(clazz)) {
            CatalogItem item = this.getCatalog().addItem(clazz);
            log.info("REST created " + item);
            return Response.created((URI)URI.create("entities/" + clazz.getName())).build();
        }
        if (AbstractPolicy.class.isAssignableFrom(clazz)) {
            CatalogItem item = this.getCatalog().addItem(clazz);
            log.info("REST created " + item);
            return Response.created((URI)URI.create("policies/" + clazz.getName())).build();
        }
        throw WebResourceUtils.preconditionFailed("Unsupported type superclass " + clazz.getSuperclass() + "; expects Entity or Policy", new Object[0]);
    }

    @Deprecated
    public static String fixLocation(String locationId) {
        if (locationId.startsWith("/v1/locations/")) {
            log.warn("REST API using legacy URI syntax for location: " + locationId);
            locationId = Strings.removeFromStart((String)locationId, (String[])new String[]{"/v1/locations/"});
        }
        return locationId;
    }
}

